/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.luis.xbackpack.world.inventory.slot.MoveableSlot;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractScrollableContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private boolean scrolling = false;
    protected int scrollOffset = 0;

    protected AbstractScrollableContainerScreen(T menu, Inventory inventory, Component titleComponent) {
        super(menu, inventory, titleComponent);
    }

    protected abstract boolean isSlotActive(Slot var1);

    protected abstract void m_7286_(PoseStack var1, float var2, int var3, int var4);

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        ItemStack mouseStack;
        this.m_7286_(stack, partialTicks, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, stack, mouseX, mouseY));
        RenderSystem.m_69465_();
        for (Widget widget : this.f_169369_) {
            widget.m_6305_(stack, mouseX, mouseY, partialTicks);
        }
        PoseStack viewStack = RenderSystem.m_157191_();
        viewStack.m_85836_();
        viewStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_97734_ = null;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.f_97732_.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
            if (this.isSlotActive(slot)) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                this.m_97799_(stack, slot);
            }
            if (!this.m_97774_(slot, mouseX, mouseY) || !this.isSlotActive(slot)) continue;
            this.f_97734_ = slot;
            if (slot instanceof MoveableSlot) {
                MoveableSlot moveableSlot = (MoveableSlot)slot;
                AbstractScrollableContainerScreen.renderSlotHighlight((PoseStack)stack, (int)slot.f_40220_, (int)moveableSlot.getY(this.scrollOffset), (int)this.m_93252_(), (int)this.getSlotColor(i));
                continue;
            }
            AbstractScrollableContainerScreen.renderSlotHighlight((PoseStack)stack, (int)slot.f_40220_, (int)slot.f_40221_, (int)this.m_93252_(), (int)this.getSlotColor(i));
        }
        this.m_7027_(stack, mouseX, mouseY);
        MinecraftForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, stack, mouseX, mouseY));
        ItemStack itemStack = mouseStack = this.f_97711_.m_41619_() ? this.f_97732_.m_142621_() : this.f_97711_;
        if (!mouseStack.m_41619_()) {
            int renderOffset = this.f_97711_.m_41619_() ? 8 : 16;
            String count = null;
            if (!this.f_97711_.m_41619_() && this.f_97710_) {
                mouseStack = mouseStack.m_41777_();
                mouseStack.m_41764_(Mth.m_14167_((float)((float)mouseStack.m_41613_() / 2.0f)));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                mouseStack = mouseStack.m_41777_();
                mouseStack.m_41764_(this.f_97720_);
                if (mouseStack.m_41619_()) {
                    count = ChatFormatting.YELLOW + "0";
                }
            }
            this.m_97782_(mouseStack, mouseX - this.f_97735_ - 8, mouseY - this.f_97736_ - renderOffset, count);
        }
        if (!this.f_97715_.m_41619_()) {
            float time = (float)(Util.m_137550_() - this.f_97714_) / 100.0f;
            if (time >= 1.0f) {
                time = 1.0f;
                this.f_97715_ = ItemStack.f_41583_;
            }
            this.m_97782_(this.f_97715_, this.f_97712_ + (int)((float)(this.f_97707_.f_40220_ - this.f_97712_) * time), this.f_97713_ + (int)((float)(this.f_97707_.f_40221_ - this.f_97713_) * time), null);
        }
        viewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
        this.m_7025_(stack, mouseX, mouseY);
    }

    public void m_97799_(PoseStack stack, Slot slot) {
        Pair pair;
        int y;
        int x = slot.f_40220_;
        if (slot instanceof MoveableSlot) {
            MoveableSlot moveableSlot = (MoveableSlot)slot;
            y = moveableSlot.getY(this.scrollOffset);
        } else {
            y = slot.f_40221_;
        }
        ItemStack slotStack = slot.m_7993_();
        boolean quickReplace = false;
        boolean shouldRender = slot == this.f_97706_ && !this.f_97711_.m_41619_() && !this.f_97710_;
        ItemStack carriedStack = this.f_97732_.m_142621_();
        String stackCount = null;
        if (slot == this.f_97706_ && !this.f_97711_.m_41619_() && this.f_97710_ && !slotStack.m_41619_()) {
            slotStack = slotStack.m_41777_();
            slotStack.m_41764_(slotStack.m_41613_() / 2);
        } else if (this.f_97738_ && this.f_97737_.contains(slot) && !carriedStack.m_41619_()) {
            if (this.f_97737_.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.m_38899_((Slot)slot, (ItemStack)carriedStack, (boolean)true) && this.f_97732_.m_5622_(slot)) {
                slotStack = carriedStack.m_41777_();
                quickReplace = true;
                AbstractContainerMenu.m_38922_((Set)this.f_97737_, (int)this.f_97717_, (ItemStack)slotStack, (int)(slot.m_7993_().m_41619_() ? 0 : slot.m_7993_().m_41613_()));
                int count = Math.min(slotStack.m_41741_(), slot.m_5866_(slotStack));
                if (slotStack.m_41613_() > count) {
                    stackCount = ChatFormatting.YELLOW.toString() + count;
                    slotStack.m_41764_(count);
                }
            } else {
                this.f_97737_.remove(slot);
                this.m_97818_();
            }
        }
        this.m_93250_(100);
        this.f_96542_.f_115093_ = 100.0f;
        if (slotStack.m_41619_() && this.isSlotActive(slot) && (pair = slot.m_7543_()) != null) {
            TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
            AbstractScrollableContainerScreen.m_93200_((PoseStack)stack, (int)x, (int)y, (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            shouldRender = true;
        }
        if (!shouldRender) {
            int modelOffset;
            if (quickReplace) {
                AbstractScrollableContainerScreen.m_93172_((PoseStack)stack, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-2130706433);
            }
            RenderSystem.m_69482_();
            if (slot instanceof MoveableSlot) {
                MoveableSlot moveableSlot = (MoveableSlot)slot;
                modelOffset = slot.f_40220_ + moveableSlot.getY(this.scrollOffset) * this.f_97726_;
            } else {
                modelOffset = slot.f_40220_ + slot.f_40221_ * this.f_97726_;
            }
            this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, slotStack, x, y, modelOffset);
            this.f_96542_.m_115174_(this.f_96547_, slotStack, x, y, stackCount);
        }
        this.f_96542_.f_115093_ = 0.0f;
        this.m_93250_(0);
    }

    public Slot m_97744_(double mouseX, double mouseY) {
        for (int i = 0; i < this.f_97732_.f_38839_.size(); ++i) {
            Slot slot = (Slot)this.f_97732_.f_38839_.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !this.isSlotActive(slot)) continue;
            return slot;
        }
        return null;
    }

    protected abstract int getScrollbarWidth();

    protected abstract int getScrollbarHeight();

    protected abstract boolean isInScrollbar(double var1, double var3);

    protected abstract int clampMouseMove(double var1);

    protected abstract int clampMouseScroll(double var1);

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isInScrollbar(mouseX, mouseY)) {
            this.scrolling = true;
            this.scrollOffset = this.clampMouseMove(mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrolling) {
            this.scrollOffset = this.clampMouseMove(mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollOffset = this.clampMouseScroll(delta);
        return true;
    }

    public boolean m_97774_(Slot slot, double mouseX, double mouseY) {
        if (slot instanceof MoveableSlot) {
            MoveableSlot moveableSlot = (MoveableSlot)slot;
            return this.m_6774_(slot.f_40220_, moveableSlot.getY(this.scrollOffset), 16, 16, mouseX, mouseY);
        }
        return this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY);
    }
}

