/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.server.commands.arguments;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.luis.xbackpack.world.extension.ExtensionState;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class ExtensionStateArgument
implements ArgumentType<ExtensionState> {
    private static final Dynamic2CommandExceptionType INVALID_EXTENSION_STATE = new Dynamic2CommandExceptionType((name, dummyObject) -> Component.m_237110_((String)"xbackpack.commands.arguments.state.invalid", (Object[])new Object[]{name}));

    private ExtensionStateArgument() {
    }

    public static ExtensionStateArgument state() {
        return new ExtensionStateArgument();
    }

    public static <S> ExtensionState get(CommandContext<S> context, String name) {
        return (ExtensionState)((Object)context.getArgument(name, ExtensionState.class));
    }

    public ExtensionState parse(StringReader reader) throws CommandSyntaxException {
        ExtensionState state = ExtensionState.fromString(reader.readUnquotedString());
        if (state != null) {
            return state;
        }
        throw INVALID_EXTENSION_STATE.create((Object)state, (Object)"");
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(Lists.newArrayList((Object[])ExtensionState.values()).stream().map(ExtensionState::getName), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Lists.newArrayList((Object[])ExtensionState.values()).stream().map(ExtensionState::getName).collect(Collectors.toList());
    }

    public static class Info
    implements ArgumentTypeInfo<ExtensionStateArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template(new ExtensionStateArgument());
        }

        public void serializeToJson(Template template, JsonObject object) {
        }

        public Template unpack(ExtensionStateArgument argument) {
            return new Template(argument);
        }

        public class Template
        implements ArgumentTypeInfo.Template<ExtensionStateArgument> {
            private final ExtensionStateArgument argument;

            public Template(ExtensionStateArgument argument) {
                this.argument = argument;
            }

            public ExtensionStateArgument instantiate(CommandBuildContext context) {
                return this.argument;
            }

            public ArgumentTypeInfo<ExtensionStateArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

