/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.capability;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.luis.xbackpack.XBackpack;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.extension.ExtensionState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;

public class BackpackConfig {
    private final Player player;
    private final Map<BackpackExtension, Data> states = Maps.newHashMap();

    public BackpackConfig(Player player) {
        this.player = player;
        for (BackpackExtension extension : BackpackExtensions.REGISTRY.get().getValues()) {
            this.states.put(extension, new Data(ExtensionState.LOCKED, 0));
        }
    }

    private Data getData(BackpackExtension extension) {
        return this.states.getOrDefault(extension, new Data(ExtensionState.LOCKED, 0));
    }

    public ExtensionState getState(BackpackExtension extension) {
        return this.getData(extension).state();
    }

    public List<BackpackExtension> getWithState(ExtensionState state) {
        return this.states.entrySet().stream().filter(entry -> ((Data)entry.getValue()).state() == state).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean setState(BackpackExtension extension, ExtensionState state) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.states.put(extension, new Data(state, player2.m_8951_().m_13017_(Stats.f_12981_, (Object)extension.getUnlockItem().m_41720_())));
            return true;
        }
        XBackpack.LOGGER.warn("Can not set the state of a BackpackExtension from the client");
        return false;
    }

    public void updateServer() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (BackpackExtension extension : BackpackExtensions.REGISTRY.get().getValues()) {
                Data data = this.getData(extension);
                ExtensionState state = data.state();
                if (state == ExtensionState.BLOCKED) continue;
                int count = player2.m_8951_().m_13017_(Stats.f_12981_, (Object)extension.getUnlockItem().m_41720_());
                if (0 >= data.unlockCount() && count > 0) {
                    this.setState(extension, ExtensionState.UNLOCKED);
                    continue;
                }
                if (data.unlockCount() <= 0 || count <= data.unlockCount()) continue;
                this.setState(extension, ExtensionState.UNLOCKED);
            }
        } else {
            XBackpack.LOGGER.warn("Can not update the BackpackConfig from the client");
        }
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        ListTag statesTag = new ListTag();
        for (Map.Entry<BackpackExtension, Data> entry : this.states.entrySet()) {
            CompoundTag stateTag = new CompoundTag();
            stateTag.m_128359_("key", BackpackExtensions.REGISTRY.get().getKey((Object)entry.getKey()).toString());
            stateTag.m_128359_("value", entry.getValue().state().getName());
            stateTag.m_128405_("unlock_count", entry.getValue().unlockCount());
            statesTag.add((Object)stateTag);
        }
        tag.m_128365_("states", (Tag)statesTag);
        return tag;
    }

    public void deserialize(CompoundTag tag) {
        ListTag statesTag = tag.m_128437_("states", 10);
        for (int i = 0; i < statesTag.size(); ++i) {
            CompoundTag stateTag = statesTag.m_128728_(i);
            BackpackExtension extension = (BackpackExtension)BackpackExtensions.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)stateTag.m_128461_("key")));
            ExtensionState state = ExtensionState.fromString(stateTag.m_128461_("value"), ExtensionState.LOCKED);
            int unlockCount = stateTag.m_128451_("unlock_count");
            if (extension == null) continue;
            this.states.put(extension, new Data(state, unlockCount));
        }
    }

    public record Data(ExtensionState state, int unlockCount) {
    }
}

