/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.capability;

import net.luis.xbackpack.BackpackConstans;
import net.luis.xbackpack.XBackpack;
import net.luis.xbackpack.network.XBNetworkHandler;
import net.luis.xbackpack.network.packet.UpdateBackpack;
import net.luis.xbackpack.world.capability.BackpackConfig;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.inventory.handler.BrewingHandler;
import net.luis.xbackpack.world.inventory.handler.CraftingHandler;
import net.luis.xbackpack.world.inventory.handler.EnchantingHandler;
import net.luis.xbackpack.world.inventory.handler.SmeltingHandler;
import net.luis.xbackpack.world.inventory.handler.progress.BrewingProgressHandler;
import net.luis.xbackpack.world.inventory.handler.progress.ProgressHandler;
import net.luis.xbackpack.world.inventory.handler.progress.SmeltingProgressHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackHandler
implements IBackpack {
    private final Player player;
    private final BackpackConfig config;
    private final ItemStackHandler backpackHandler = new ItemStackHandler(873);
    private final ItemStackHandler toolHandler = new ItemStackHandler(3);
    private final ItemStackHandler craftingHandler = new ItemStackHandler(9);
    private final SmeltingHandler furnaceHandler = new SmeltingHandler(1, 4, 4);
    private final SmeltingProgressHandler smeltHandler;
    private final CraftingHandler anvilHandler = new CraftingHandler(2, 1);
    private final EnchantingHandler enchantingHandler = new EnchantingHandler(1, 1, 1);
    private final CraftingHandler stonecutterHandler = new CraftingHandler(1, 1);
    private final BrewingHandler brewingHandler = new BrewingHandler(1, 3);
    private final BrewingProgressHandler brewHandler;
    private final CraftingHandler grindstoneHandler = new CraftingHandler(2, 1);
    private final CraftingHandler smithingHandler = new CraftingHandler(2, 1);

    public BackpackHandler(Player player) {
        this.player = player;
        this.config = new BackpackConfig(this.player);
        this.smeltHandler = new SmeltingProgressHandler(this.player, this.furnaceHandler, BackpackConstans.FURNACE_RECIPE_TYPES);
        this.brewHandler = new BrewingProgressHandler(this.player, this.brewingHandler);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public BackpackConfig getConfig() {
        return this.config;
    }

    @Override
    public ItemStackHandler getBackpackHandler() {
        return this.backpackHandler;
    }

    @Override
    public ItemStackHandler getToolHandler() {
        return this.toolHandler;
    }

    @Override
    public ItemStackHandler getCraftingHandler() {
        return this.craftingHandler;
    }

    @Override
    public SmeltingHandler getSmeltingHandler() {
        return this.furnaceHandler;
    }

    @Override
    public ProgressHandler getSmeltHandler() {
        return this.smeltHandler;
    }

    @Override
    public CraftingHandler getAnvilHandler() {
        return this.anvilHandler;
    }

    @Override
    public EnchantingHandler getEnchantingHandler() {
        return this.enchantingHandler;
    }

    @Override
    public CraftingHandler getStonecutterHandler() {
        return this.stonecutterHandler;
    }

    @Override
    public BrewingHandler getBrewingHandler() {
        return this.brewingHandler;
    }

    @Override
    public ProgressHandler getBrewHandler() {
        return this.brewHandler;
    }

    @Override
    public CraftingHandler getGrindstoneHandler() {
        return this.grindstoneHandler;
    }

    @Override
    public CraftingHandler getSmithingHandler() {
        return this.smithingHandler;
    }

    @Override
    public void tick() {
        this.smeltHandler.tick();
        this.brewHandler.tick();
    }

    @Override
    public boolean broadcastChanges() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.config.updateServer();
            XBNetworkHandler.sendToPlayer(player2, new UpdateBackpack(this.serialize()));
            return true;
        }
        XBackpack.LOGGER.warn("Can not broadcast changes on the client");
        return false;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("backpack_config", (Tag)this.config.serialize());
        tag.m_128365_("backpack_handler", (Tag)this.backpackHandler.serializeNBT());
        tag.m_128365_("tool_handler", (Tag)this.toolHandler.serializeNBT());
        tag.m_128365_("crafting_handler", (Tag)this.craftingHandler.serializeNBT());
        tag.m_128365_("furnace_handler", (Tag)this.furnaceHandler.serialize());
        tag.m_128365_("smelt_handler", (Tag)this.smeltHandler.serialize());
        tag.m_128365_("anvil_handler", (Tag)this.anvilHandler.serialize());
        tag.m_128365_("enchanting_handler", (Tag)this.enchantingHandler.serialize());
        tag.m_128365_("stonecutter_handler", (Tag)this.stonecutterHandler.serialize());
        tag.m_128365_("brewing_handler", (Tag)this.brewingHandler.serialize());
        tag.m_128365_("brew_handler", (Tag)this.brewHandler.serialize());
        tag.m_128365_("grindstone_handler", (Tag)this.grindstoneHandler.serialize());
        tag.m_128365_("smithing_handler", (Tag)this.smithingHandler.serialize());
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        if (tag.m_128441_("Size") && tag.m_128441_("Items")) {
            this.deserializeOld(tag);
        } else {
            if (tag.m_128441_("backpack_config")) {
                this.config.deserialize(tag.m_128469_("backpack_config"));
            }
            this.backpackHandler.deserializeNBT(tag.m_128469_("backpack_handler"));
            this.toolHandler.deserializeNBT(tag.m_128469_("tool_handler"));
            this.craftingHandler.deserializeNBT(tag.m_128469_("crafting_handler"));
            this.furnaceHandler.deserialize(tag.m_128469_("furnace_handler"));
            this.smeltHandler.deserialize(tag.m_128469_("smelt_handler"));
            this.anvilHandler.deserialize(tag.m_128469_("anvil_handler"));
            this.enchantingHandler.deserialize(tag.m_128469_("enchanting_handler"));
            this.stonecutterHandler.deserialize(tag.m_128469_("stonecutter_handler"));
            this.brewingHandler.deserialize(tag.m_128469_("brewing_handler"));
            this.brewHandler.deserialize(tag.m_128469_("brew_handler"));
            this.grindstoneHandler.deserialize(tag.m_128469_("grindstone_handler"));
            this.smithingHandler.deserialize(tag.m_128469_("smithing_handler"));
        }
    }

    private void deserializeOld(CompoundTag tag) {
        XBackpack.LOGGER.info("Convert the old disk format into new format");
        ListTag items = tag.m_128437_("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.m_128728_(i);
            int slot = item.m_128451_("Slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)item);
            if (slot >= 0 && slot < this.backpackHandler.getSlots()) {
                this.backpackHandler.setStackInSlot(slot, stack);
                continue;
            }
            int toolSlot = slot - 873;
            if (2 >= toolSlot && toolSlot >= 0) {
                this.toolHandler.setStackInSlot(toolSlot, stack);
                continue;
            }
            if (stack.m_41619_()) continue;
            XBackpack.LOGGER.error("Fail to convert slot {} with item {} into the new disk format, the item will be destroyed", (Object)slot, (Object)stack.m_41720_());
        }
    }
}

