/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import java.util.Map;
import java.util.function.Consumer;
import net.luis.xbackpack.network.XBNetworkHandler;
import net.luis.xbackpack.network.packet.extension.UpdateAnvilExtension;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.handler.CraftingHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class AnvilExtensionMenu
extends AbstractExtensionMenu {
    private final CraftingHandler handler;
    private int repairItemCountCost;
    private int cost;

    public AnvilExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)BackpackExtensions.ANVIL.get());
        this.handler = BackpackProvider.get(this.player).getAnvilHandler();
    }

    @Override
    public void open() {
        if (!this.handler.getInputHandler().getStackInSlot(0).m_41619_() || !this.handler.getInputHandler().getStackInSlot(1).m_41619_()) {
            this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
            this.createResult();
        }
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 0, 225, 73));
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 1, 260, 73));
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getResultHandler(), 0, 304, 73){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return AnvilExtensionMenu.this.mayPickup(player);
            }

            public void m_142406_(Player player, ItemStack stack) {
                AnvilExtensionMenu.this.onTake(player, stack);
                super.m_142406_(player, stack);
            }
        });
    }

    public boolean mayPickup(Player player) {
        return (player.m_150110_().f_35937_ || player.f_36078_ >= this.cost) && this.cost > 0;
    }

    private void onTake(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!serverPlayer.m_150110_().f_35937_) {
                serverPlayer.m_6749_(-this.cost);
            }
            this.handler.getInputHandler().setStackInSlot(0, ItemStack.f_41583_);
            if (this.repairItemCountCost > 0) {
                ItemStack rigthStack = this.handler.getInputHandler().getStackInSlot(1);
                if (!rigthStack.m_41619_() && rigthStack.m_41613_() > this.repairItemCountCost) {
                    rigthStack.m_41774_(this.repairItemCountCost);
                    this.handler.getInputHandler().setStackInSlot(1, rigthStack);
                } else {
                    this.handler.getInputHandler().setStackInSlot(1, ItemStack.f_41583_);
                }
            } else {
                this.handler.getInputHandler().setStackInSlot(1, ItemStack.f_41583_);
            }
            this.cost = 0;
            this.playSound(serverPlayer, serverPlayer.m_9236_());
        }
        this.menu.m_38946_();
        this.broadcastChanges();
        this.createResult();
    }

    private void playSound(ServerPlayer player, ServerLevel level) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(SoundEvents.f_11671_, SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f, level.f_46441_.m_188505_()));
    }

    @Override
    public void slotsChanged() {
        this.createResult();
    }

    private void createResult() {
        ItemStack leftStack = this.handler.getInputHandler().getStackInSlot(0);
        this.cost = 1;
        int enchantCost = 0;
        int repairCost = 0;
        int renameCost = 0;
        if (leftStack.m_41619_()) {
            this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
            this.cost = 0;
            this.broadcastChanges();
        } else {
            ItemStack resultStack = leftStack.m_41777_();
            ItemStack rightStack = this.handler.getInputHandler().getStackInSlot(1);
            Map map = EnchantmentHelper.m_44831_((ItemStack)resultStack);
            int n = rightStack.m_41619_() ? 0 : rightStack.m_41610_();
            this.repairItemCountCost = 0;
            boolean enchantedBook = false;
            if (!this.onAnvilUpdate(leftStack, rightStack, repairCost += leftStack.m_41610_() + n)) {
                return;
            }
            if (!rightStack.m_41619_()) {
                boolean bl = enchantedBook = rightStack.m_41720_() == Items.f_42690_ && !EnchantedBookItem.m_41163_((ItemStack)rightStack).isEmpty();
                if (resultStack.m_41763_() && resultStack.m_41720_().m_6832_(leftStack, rightStack)) {
                    int currentRepairCost;
                    int damage = Math.min(resultStack.m_41773_(), resultStack.m_41776_() / 4);
                    if (damage <= 0) {
                        this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                        this.cost = 0;
                        this.broadcastChanges();
                        return;
                    }
                    for (currentRepairCost = 0; damage > 0 && currentRepairCost < rightStack.m_41613_(); ++currentRepairCost) {
                        int currentDamage = resultStack.m_41773_() - damage;
                        resultStack.m_41721_(currentDamage);
                        ++enchantCost;
                        damage = Math.min(resultStack.m_41773_(), resultStack.m_41776_() / 4);
                    }
                    this.repairItemCountCost = currentRepairCost;
                } else {
                    if (!(enchantedBook || resultStack.m_150930_(rightStack.m_41720_()) && resultStack.m_41763_())) {
                        this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                        this.cost = 0;
                        this.broadcastChanges();
                        return;
                    }
                    if (resultStack.m_41763_() && !enchantedBook) {
                        int leftDamage = leftStack.m_41776_() - leftStack.m_41773_();
                        int rightDamage = rightStack.m_41776_() - rightStack.m_41773_();
                        int resultDamage = rightDamage + resultStack.m_41776_() * 12 / 100;
                        int combindDamage = leftDamage + resultDamage;
                        int damage = resultStack.m_41776_() - combindDamage;
                        if (damage < 0) {
                            damage = 0;
                        }
                        if (damage < resultStack.m_41773_()) {
                            resultStack.m_41721_(damage);
                            enchantCost += 2;
                        }
                    }
                    Map rightEnchantments = EnchantmentHelper.m_44831_((ItemStack)rightStack);
                    boolean canEnchant = false;
                    boolean survival = false;
                    for (Enchantment rightEnchantment : rightEnchantments.keySet()) {
                        int rightLevel;
                        if (rightEnchantment == null) continue;
                        int resultLevel = map.getOrDefault(rightEnchantment, 0);
                        rightLevel = resultLevel == (rightLevel = ((Integer)rightEnchantments.get(rightEnchantment)).intValue()) ? rightLevel + 1 : Math.max(rightLevel, resultLevel);
                        boolean canEnchantOrCreative = rightEnchantment.m_6081_(leftStack);
                        if (this.player.m_150110_().f_35937_ || leftStack.m_150930_(Items.f_42690_)) {
                            canEnchantOrCreative = true;
                        }
                        for (Enchantment enchantment : map.keySet()) {
                            if (enchantment == rightEnchantment || rightEnchantment.m_44695_(enchantment)) continue;
                            canEnchantOrCreative = false;
                            ++enchantCost;
                        }
                        if (!canEnchantOrCreative) {
                            survival = true;
                            continue;
                        }
                        canEnchant = true;
                        if (rightLevel > rightEnchantment.m_6586_()) {
                            rightLevel = rightEnchantment.m_6586_();
                        }
                        map.put(rightEnchantment, rightLevel);
                        int rarityCost = 0;
                        switch (rightEnchantment.m_44699_()) {
                            case COMMON: {
                                rarityCost = 1;
                                break;
                            }
                            case UNCOMMON: {
                                rarityCost = 2;
                                break;
                            }
                            case RARE: {
                                rarityCost = 4;
                                break;
                            }
                            case VERY_RARE: {
                                rarityCost = 8;
                            }
                        }
                        if (enchantedBook) {
                            rarityCost = Math.max(1, rarityCost / 2);
                        }
                        enchantCost += rarityCost * rightLevel;
                        if (leftStack.m_41613_() <= 1) continue;
                        enchantCost = 40;
                    }
                    if (survival && !canEnchant) {
                        this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
                        this.cost = 0;
                        this.broadcastChanges();
                        return;
                    }
                }
            }
            if (enchantedBook && !resultStack.isBookEnchantable(rightStack)) {
                resultStack = ItemStack.f_41583_;
            }
            this.cost = 0;
            this.cost = repairCost + enchantCost;
            if (enchantCost <= 0) {
                resultStack = ItemStack.f_41583_;
            }
            if (renameCost == enchantCost && renameCost > 0 && this.cost >= 40) {
                this.cost = 39;
            }
            if (this.cost >= 40 && !this.player.m_150110_().f_35937_) {
                resultStack = ItemStack.f_41583_;
            }
            if (!resultStack.m_41619_()) {
                int baseRepairCost = resultStack.m_41610_();
                if (!rightStack.m_41619_() && baseRepairCost < rightStack.m_41610_()) {
                    baseRepairCost = rightStack.m_41610_();
                }
                if (renameCost != enchantCost || renameCost == 0) {
                    baseRepairCost = AnvilExtensionMenu.calculateIncreasedRepairCost(baseRepairCost);
                }
                resultStack.m_41742_(baseRepairCost);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)resultStack);
            }
            this.handler.getResultHandler().setStackInSlot(0, resultStack);
            this.menu.m_38946_();
            this.broadcastChanges();
        }
    }

    private void broadcastChanges() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            XBNetworkHandler.sendToPlayer(player2, new UpdateAnvilExtension(this.cost));
        }
    }

    private static int calculateIncreasedRepairCost(int cost) {
        return cost * 2 + 1;
    }

    public int getCost() {
        return this.cost;
    }

    private boolean onAnvilUpdate(ItemStack leftStack, ItemStack rightStack, int repairCost) {
        AnvilUpdateEvent event = new AnvilUpdateEvent(leftStack, rightStack, leftStack.m_41611_().getString(), repairCost, this.player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getOutput().m_41619_()) {
            return true;
        }
        this.handler.getResultHandler().setStackInSlot(0, event.getOutput());
        this.cost = event.getCost();
        this.repairItemCountCost = event.getMaterialCost();
        this.broadcastChanges();
        return false;
    }

    @Override
    public void close() {
        this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
    }
}

