/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import java.util.Optional;
import java.util.function.Consumer;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionResultSlot;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.wrapper.CraftingContainerWrapper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CraftingExtensionMenu
extends AbstractExtensionMenu {
    private final CraftingContainerWrapper craftingWrapper;
    private final ResultContainer resultWrapper;

    public CraftingExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)BackpackExtensions.CRAFTING_TABLE.get());
        this.craftingWrapper = new CraftingContainerWrapper(this.menu, (IItemHandlerModifiable)BackpackProvider.get(this.player).getCraftingHandler(), 3, 3);
        this.resultWrapper = new ResultContainer();
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.craftingWrapper, j + i * 3, 225 + j * 18, 25 + i * 18));
            }
        }
        consumer.accept((Slot)new ExtensionResultSlot(this, this.player, this.craftingWrapper, (Container)this.resultWrapper, 0, 243, 110));
    }

    @Override
    public void slotsChanged(Container container) {
        if (container == this.craftingWrapper) {
            this.slotChangedCraftingGrid();
        }
    }

    private void slotChangedCraftingGrid() {
        Player player;
        Level level = this.player.f_19853_;
        if (!level.f_46443_ && (player = this.player) instanceof ServerPlayer) {
            CraftingRecipe recipe;
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack stack = ItemStack.f_41583_;
            Optional optional = level.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.craftingWrapper, level);
            if (optional.isPresent() && this.resultWrapper.m_40135_(level, player2, (Recipe)(recipe = (CraftingRecipe)optional.get()))) {
                stack = recipe.m_5874_((Container)this.craftingWrapper);
            }
            this.resultWrapper.m_6836_(0, stack);
            BackpackProvider.get(this.player).broadcastChanges();
        }
    }
}

