/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import java.util.function.Consumer;
import net.luis.xbackpack.BackpackConstans;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.capability.IBackpack;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.extension.slot.FurnaceExtensionResultSlot;
import net.luis.xbackpack.world.inventory.handler.SmeltingHandler;
import net.luis.xbackpack.world.inventory.handler.progress.ProgressHandler;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;

public class FurnaceExtensionMenu
extends AbstractExtensionMenu {
    private final SmeltingHandler handler;
    private final ProgressHandler progressHandler;

    public FurnaceExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)BackpackExtensions.FURNACE.get());
        IBackpack backpack = BackpackProvider.get(this.player);
        this.handler = backpack.getSmeltingHandler();
        this.progressHandler = backpack.getSmeltHandler();
    }

    @Override
    public void open() {
        this.progressHandler.broadcastChanges();
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        int i;
        for (i = 0; i < 4; ++i) {
            consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputStorageHandler(), i, 225 + i * 18, 49){

                public boolean m_5857_(ItemStack stack) {
                    return FurnaceExtensionMenu.canSmelt(FurnaceExtensionMenu.this.player, stack);
                }
            });
        }
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 0, 225, 71){

            public boolean m_5857_(ItemStack stack) {
                return FurnaceExtensionMenu.canSmelt(FurnaceExtensionMenu.this.player, stack);
            }
        });
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getFuelHandler(), 0, 225, 107){

            public boolean m_5857_(ItemStack stack) {
                return FurnaceExtensionMenu.isFuel(stack) || stack.m_150930_(Items.f_42446_);
            }

            public int m_5866_(ItemStack stack) {
                return stack.m_150930_(Items.f_42446_) ? 1 : super.m_5866_(stack);
            }
        });
        consumer.accept((Slot)new FurnaceExtensionResultSlot(this, this.player, (IItemHandler)this.handler.getResultHandler(), 0, 275, 89));
        for (i = 0; i < 4; ++i) {
            consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getResultStorageHandler(), i, 225 + i * 18, 129){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }
            });
        }
    }

    public static boolean canSmelt(Player player, ItemStack stack) {
        for (RecipeType<? extends AbstractCookingRecipe> recipeType : BackpackConstans.FURNACE_RECIPE_TYPES) {
            if (!player.f_19853_.m_7465_().m_44015_(recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), player.f_19853_).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static boolean isFuel(ItemStack stack) {
        for (RecipeType<? extends AbstractCookingRecipe> recipeType : BackpackConstans.FURNACE_RECIPE_TYPES) {
            if (ForgeHooks.getBurnTime((ItemStack)stack, recipeType) <= 0) continue;
            return true;
        }
        return false;
    }
}

