/*
 * Decompiled with CFR 0.152.
 */
package net.luis.xbackpack.world.inventory.extension;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.luis.xbackpack.network.XBNetworkHandler;
import net.luis.xbackpack.network.packet.extension.UpdateStonecutterExtension;
import net.luis.xbackpack.world.capability.BackpackProvider;
import net.luis.xbackpack.world.extension.BackpackExtension;
import net.luis.xbackpack.world.extension.BackpackExtensions;
import net.luis.xbackpack.world.inventory.BackpackMenu;
import net.luis.xbackpack.world.inventory.extension.AbstractExtensionMenu;
import net.luis.xbackpack.world.inventory.extension.slot.ExtensionSlot;
import net.luis.xbackpack.world.inventory.handler.CraftingHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraftforge.items.IItemHandler;

public class StonecutterExtensionMenu
extends AbstractExtensionMenu {
    private final CraftingHandler handler;
    private final List<StonecutterRecipe> recipes = Lists.newArrayList();
    private ItemStack input = ItemStack.f_41583_;
    private int selectedRecipe = -1;
    private StonecutterRecipe recipe;

    public StonecutterExtensionMenu(BackpackMenu menu, Player player) {
        super(menu, player, (BackpackExtension)BackpackExtensions.STONECUTTER.get());
        this.handler = BackpackProvider.get(this.player).getStonecutterHandler();
    }

    @Override
    public void open() {
        this.slotsChanged();
    }

    @Override
    public void addSlots(Consumer<Slot> consumer) {
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getInputHandler(), 0, 249, 121));
        consumer.accept((Slot)new ExtensionSlot(this, (IItemHandler)this.handler.getResultHandler(), 0, 249, 207){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                StonecutterExtensionMenu.this.onTake(player, stack);
                super.m_142406_(player, stack);
            }
        });
    }

    private void onTake(Player player, ItemStack stack) {
        ItemStack inputStack;
        stack.m_41678_(player.f_19853_, player, stack.m_41613_());
        if (this.recipe != null && !this.recipe.m_5598_()) {
            player.m_7281_(Collections.singleton(this.recipe));
        }
        if (!(inputStack = this.handler.getInputHandler().extractItem(0, 1, false)).m_41619_() && !this.handler.getInputHandler().getStackInSlot(0).m_41619_()) {
            this.setupResult();
        }
        this.menu.m_38946_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.playSound(serverPlayer, serverPlayer.m_9236_());
        }
    }

    private void playSound(ServerPlayer player, ServerLevel level) {
        player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(SoundEvents.f_12494_, SoundSource.BLOCKS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f, level.f_46441_.m_188505_()));
    }

    @Override
    public boolean requiresTickUpdate() {
        ItemStack input = this.handler.getInputHandler().getStackInSlot(0);
        ItemStack result = this.handler.getResultHandler().getStackInSlot(0);
        if (result.m_41619_() && !this.recipes.isEmpty()) {
            return true;
        }
        return !input.m_41619_() && this.recipes.isEmpty();
    }

    @Override
    public void slotsChanged() {
        ItemStack stack = this.handler.getInputHandler().getStackInSlot(0);
        if (!stack.m_150930_(this.input.m_41720_())) {
            this.input = stack.m_41777_();
            this.setupRecipes(stack);
        } else {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                XBNetworkHandler.sendToPlayer(player2, new UpdateStonecutterExtension(false));
            }
        }
    }

    private void setupRecipes(ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe = -1;
        this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
        this.recipes.addAll(this.player.f_19853_.m_7465_().m_44056_(RecipeType.f_44112_, (Container)new SimpleContainer(new ItemStack[]{stack}), this.player.f_19853_));
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            XBNetworkHandler.sendToPlayer(player2, new UpdateStonecutterExtension(true));
        }
    }

    @Override
    public boolean clickMenuButton(Player player, int button) {
        if (this.isValidIndex(button)) {
            this.selectedRecipe = button;
            this.setupResult();
            return true;
        }
        return true;
    }

    private void setupResult() {
        if (!this.recipes.isEmpty() && this.isValidIndex(this.selectedRecipe)) {
            StonecutterRecipe recipe = this.recipes.get(this.selectedRecipe);
            this.handler.getResultHandler().setStackInSlot(0, recipe.m_5874_((Container)new SimpleContainer(new ItemStack[]{this.handler.getInputHandler().getStackInSlot(0)})));
            this.recipe = recipe;
        } else {
            this.handler.getResultHandler().setStackInSlot(0, ItemStack.f_41583_);
        }
        this.menu.m_38946_();
    }

    private boolean isValidIndex(int index) {
        return this.recipes.size() > index && index >= 0;
    }
}

