/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.colored_water.cauldrons.block.base;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractLeveledCauldronBlock
extends AbstractCauldronBlock {
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61418_;

    public AbstractLeveledCauldronBlock(BlockBehaviour.Properties settings, Map<Item, CauldronInteraction> behaviorMap) {
        super(settings, behaviorMap);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    public static IntegerProperty getLevelProperty() {
        return LEVEL;
    }

    public static int getMaxLevel() {
        return 3;
    }

    public static int getFluidLevel(BlockState state) {
        return (Integer)state.m_61143_((Property)AbstractLeveledCauldronBlock.getLevelProperty());
    }

    public static boolean setFluidLevel(BlockState state, Level world, BlockPos pos, boolean required, int level) {
        int actualLevel = Math.max(0, Math.min(level, AbstractLeveledCauldronBlock.getMaxLevel()));
        if (level != actualLevel && required || AbstractLeveledCauldronBlock.getFluidLevel(state) == actualLevel) {
            return false;
        }
        return world.m_46597_(pos, actualLevel == 0 ? Blocks.f_50256_.m_49966_() : (BlockState)state.m_61122_((Property)AbstractLeveledCauldronBlock.getLevelProperty()));
    }

    public static boolean decrementFluidLevel(BlockState state, Level world, BlockPos pos, boolean required, int amount) {
        int level = AbstractLeveledCauldronBlock.getFluidLevel(state) - amount;
        return AbstractLeveledCauldronBlock.setFluidLevel(state, world, pos, required, level);
    }

    public static boolean incrementFluidLevel(BlockState state, Level world, BlockPos pos, boolean required, int amount) {
        int level = AbstractLeveledCauldronBlock.getFluidLevel(state) + amount;
        return AbstractLeveledCauldronBlock.setFluidLevel(state, world, pos, required, level);
    }

    public static boolean decrementFluidLevel(BlockState state, Level world, BlockPos pos) {
        return AbstractLeveledCauldronBlock.decrementFluidLevel(state, world, pos, true, 1);
    }

    public static boolean incrementFluidLevel(BlockState state, Level world, BlockPos pos) {
        return AbstractLeveledCauldronBlock.incrementFluidLevel(state, world, pos, true, 1);
    }

    public static boolean decrementFluidLevel(BlockState state, Level world, BlockPos pos, int amount) {
        return AbstractLeveledCauldronBlock.decrementFluidLevel(state, world, pos, true, amount);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51305_) {
        p_51305_.m_61104_(new Property[]{LEVEL});
    }

    private double getLevelAsThirds(BlockState state) {
        return (double)AbstractLeveledCauldronBlock.getFluidLevel(state) / ((double)AbstractLeveledCauldronBlock.getMaxLevel() / 3.0);
    }

    public boolean setFluidLevel(BlockState state, Level world, BlockPos pos, int level) {
        return AbstractLeveledCauldronBlock.setFluidLevel(state, world, pos, true, level);
    }

    public boolean decrementFluidLevel(BlockState state, Level world, BlockPos pos, boolean required) {
        return AbstractLeveledCauldronBlock.decrementFluidLevel(state, world, pos, required, 1);
    }

    public boolean incrementFluidLevel(BlockState state, Level world, BlockPos pos, boolean required) {
        return AbstractLeveledCauldronBlock.incrementFluidLevel(state, world, pos, required, 1);
    }

    public boolean incrementFluidLevel(BlockState state, Level world, BlockPos pos, int amount) {
        return AbstractLeveledCauldronBlock.incrementFluidLevel(state, world, pos, true, amount);
    }

    public boolean m_142596_(BlockState state) {
        return (Integer)state.m_61143_((Property)AbstractLeveledCauldronBlock.getLevelProperty()) == AbstractLeveledCauldronBlock.getMaxLevel();
    }
}

