/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.block.entity.farm.OceanFarmEntity;
import de.markusbordihn.easymobfarm.config.biome.Ocean;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OceanFarm
extends MobFarmBlock {
    public static final String NAME = "ocean_farm";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final Set<String> acceptedMobTypes = Ocean.All;

    public OceanFarm(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isAcceptedCapturedMobType(String mobType) {
        return acceptedMobTypes.contains(mobType);
    }

    @Override
    public Set<String> getAcceptedMobTypes() {
        return acceptedMobTypes;
    }

    @Override
    public boolean isAcceptedMobType(String mobType) {
        return acceptedMobTypes.contains(mobType);
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new OceanFarmEntity((BlockEntityType)ModBlocks.OCEAN_FARM_ENTITY.get(), blockPos, blockState);
    }

    @Override
    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof OceanFarmEntity) {
            OceanFarmEntity oceanFarmEntity = (OceanFarmEntity)blockEntity;
            player.m_5893_((MenuProvider)oceanFarmEntity);
        }
    }

    @Override
    public InteractionResult consumeCapturedMob(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack, UseOnContext context) {
        OceanFarmEntity chickenMobFarmEntity = (OceanFarmEntity)blockEntity;
        chickenMobFarmEntity.updateLevel(level);
        if (!chickenMobFarmEntity.hasItem(0)) {
            chickenMobFarmEntity.m_6836_(0, itemStack);
            context.m_43723_().m_21008_(context.m_43724_(), ItemStack.f_41583_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : OceanFarm.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.OCEAN_FARM_ENTITY.get()), MobFarmBlockEntity::serverTick);
    }
}

