/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity.farm;

import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.menu.farm.CreativeMobFarmMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class CreativeMobFarmEntity
extends MobFarmBlockEntity {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int creativeMobFarmProcessTime = (Integer)CreativeMobFarmEntity.COMMON.creativeMobFarmProcessTime.get();
    private static int farmProcessingTime = 0;

    public CreativeMobFarmEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.CREATIVE_MOB_FARM_ENTITY.get(), blockPos, blockState);
    }

    public CreativeMobFarmEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        creativeMobFarmProcessTime = (Integer)CreativeMobFarmEntity.COMMON.creativeMobFarmProcessTime.get();
        farmProcessingTime = creativeMobFarmProcessTime * 20;
        log.info("{}: CreativeMobFarm Entity with drops every {}s", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", (Object)creativeMobFarmProcessTime);
    }

    @Override
    protected Component m_6820_() {
        return new TranslatableComponent("container.easy_mob_farm.creative_mob_farm");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new CreativeMobFarmMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    @Override
    public int getFarmProcessingTime() {
        return farmProcessingTime;
    }

    @Override
    public void processAdditionalEffects(Level level, BlockPos blockPos, MobFarmBlockEntity blockEntity, ItemStack capturedMob) {
        super.processAdditionalEffects(level, blockPos, blockEntity, capturedMob);
        level.m_5594_(null, blockPos, SoundEvents.f_11752_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

