/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.helper.RenderModels;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderHelper {
    public static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected Minecraft minecraft;
    protected BlockEntity blockEntity;
    protected int renderId;
    private Random random = new Random();
    private float headRotation = this.random.nextFloat(-12.0f, 12.0f);
    private float bodyRotation = this.random.nextFloat(-12.0f, 12.0f);
    private Quaternion blockRotation;
    private RenderModels renderModels;
    private DyeColor entityColor;

    public RenderHelper(int renderId, Minecraft minecraft, BlockEntity blockEntity) {
        this.minecraft = minecraft;
        this.blockEntity = blockEntity;
        this.renderId = renderId;
        this.renderModels = new RenderModels(minecraft);
    }

    public Quaternion getBlockRotation() {
        if (this.blockRotation == null) {
            this.blockRotation = Vector3f.f_122225_.m_122240_(-((Direction)this.blockEntity.m_58900_().m_61143_((Property)MobFarmBlock.FACING)).m_122435_() + this.bodyRotation);
        }
        return this.blockRotation;
    }

    public float getRandomBodyRotation() {
        return this.bodyRotation;
    }

    public float getRandomHeadRotation() {
        return this.headRotation;
    }

    public DyeColor getEntityColor() {
        BlockEntity blockEntity;
        if (this.entityColor == null && (blockEntity = this.blockEntity) instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
            this.entityColor = mobFarmBlockEntity.getFarmMobColor();
        }
        return this.entityColor;
    }

    public void renderCustomEntity(EntityType<?> entityType, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        Entity entity = this.renderModels.getCustomEntity(entityType);
        if (entity != null) {
            this.renderModels.getEntityRendererDispatcher().m_114384_(entity, 0.0, 0.0, 0.0, 1.0f, this.headRotation, poseStack, buffer, combinedLight);
        }
    }

    public float getCustomEntityScale() {
        return this.renderModels.getCustomEntityScale();
    }

    public void renderCaveSpider(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, -180.0f, -180.0f, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getCaveSpiderRenderer(), (LivingEntity)this.renderModels.getCaveSpider());
    }

    public void renderCod(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, -90.0f, -90.0f, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getCodRenderer(), (LivingEntity)this.renderModels.getCod());
    }

    public void renderCow(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getCowRenderer(), (LivingEntity)this.renderModels.getCow());
    }

    public void renderCreeper(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getCreeperRenderer(), (LivingEntity)this.renderModels.getCreeper());
    }

    public void renderChicken(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getChickenRenderer(), (LivingEntity)this.renderModels.getChicken());
    }

    public void renderDrowned(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getDrownedRenderer(), (LivingEntity)this.renderModels.getDrowned());
    }

    public void renderPig(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getPigRenderer(), (LivingEntity)this.renderModels.getPig());
    }

    public void renderSheep(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getSheepRenderer(), (LivingEntity)this.renderModels.getSheep(this.getEntityColor()));
    }

    public void renderSkeleton(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getSkeletonRenderer(), (LivingEntity)this.renderModels.getSkeleton());
    }

    public void renderSquid(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getSquidRenderer(), (LivingEntity)this.renderModels.getSquid());
    }

    public void renderGlowSquid(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getGlowSquidRenderer(), (LivingEntity)this.renderModels.getGlowSquid());
    }

    public void renderZombie(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight) {
        this.renderModel(poseStack, buffer, scale, x, y, z, combinedLight, (LivingEntityRenderer)this.renderModels.getZombieRenderer(), (LivingEntity)this.renderModels.getZombie());
    }

    public boolean renderAnimal(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, String farmMobType) {
        switch (farmMobType) {
            case "minecraft:chicken": {
                this.renderChicken(poseStack, buffer, 0.6f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            case "minecraft:cow": {
                this.renderCow(poseStack, buffer, 0.35f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            case "minecraft:pig": {
                this.renderPig(poseStack, buffer, 0.38f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            case "minecraft:sheep": {
                this.renderSheep(poseStack, buffer, 0.38f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean renderMonster(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, String farmMobType) {
        switch (farmMobType) {
            case "minecraft:cave_spider": {
                this.renderCaveSpider(poseStack, buffer, 0.35f, 0.0, 0.9375, 0.125, combinedLight);
                break;
            }
            case "minecraft:creeper": {
                this.renderCreeper(poseStack, buffer, 0.25f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            case "minecraft:skeleton": {
                this.renderSkeleton(poseStack, buffer, 0.25f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            case "minecraft:zombie": {
                this.renderZombie(poseStack, buffer, 0.25f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean renderWaterEntity(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, String farmMobType) {
        switch (farmMobType) {
            case "minecraft:cod": {
                this.renderCod(poseStack, buffer, 0.3f, 0.0, 0.3125, 0.125, combinedLight);
                break;
            }
            case "minecraft:squid": {
                this.renderSquid(poseStack, buffer, 0.3f, 0.0, 0.4375, 0.125, combinedLight);
                break;
            }
            case "minecraft:glow_squid": {
                this.renderGlowSquid(poseStack, buffer, 0.3f, 0.0, 0.4375, 0.125, combinedLight);
                break;
            }
            case "minecraft:drowned": {
                this.renderDrowned(poseStack, buffer, 0.25f, 0.0, 0.0, 0.125, combinedLight);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean renderLivingEntity(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, EntityType<?> entityType) {
        if (entityType == null) {
            return false;
        }
        this.renderCustomModel(poseStack, buffer, 0.0, 0.0, 0.0625, combinedLight, entityType);
        return true;
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void renderModel(PoseStack poseStack, MultiBufferSource buffer, float scale, float rotationX, float rotationY, double x, double y, double z, int combinedLight, LivingEntityRenderer<T, M> renderer, T livingEntity) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0625, 0.5);
        poseStack.m_85845_(this.getBlockRotation());
        poseStack.m_85837_(x, y, z);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(rotationX));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotationY));
        poseStack.m_85841_(scale, scale, scale);
        renderer.m_7392_(livingEntity, 0.0f, this.getRandomHeadRotation(), poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void renderModel(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight, LivingEntityRenderer<T, M> renderer, T livingEntity) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0625, 0.5);
        poseStack.m_85845_(this.getBlockRotation());
        poseStack.m_85837_(x, y, z);
        poseStack.m_85841_(scale, scale, scale);
        renderer.m_7392_(livingEntity, 0.0f, this.getRandomHeadRotation(), poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }

    public void renderCustomModel(PoseStack poseStack, MultiBufferSource buffer, float scale, float rotationX, float rotationY, double x, double y, double z, int combinedLight, EntityType<?> entityType) {
        if (entityType != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0625, 0.5);
            poseStack.m_85845_(this.getBlockRotation());
            poseStack.m_85837_(x, y, z);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(rotationX));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotationY));
            poseStack.m_85841_(scale, scale, scale);
            this.renderCustomEntity(entityType, poseStack, buffer, combinedLight);
            poseStack.m_85849_();
        }
    }

    public void renderCustomModel(PoseStack poseStack, MultiBufferSource buffer, float scale, double x, double y, double z, int combinedLight, EntityType<?> entityType) {
        if (entityType != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0625, 0.5);
            poseStack.m_85845_(this.getBlockRotation());
            poseStack.m_85837_(x, y, z);
            poseStack.m_85841_(scale, scale, scale);
            this.renderCustomEntity(entityType, poseStack, buffer, combinedLight);
            poseStack.m_85849_();
        }
    }

    public void renderCustomModel(PoseStack poseStack, MultiBufferSource buffer, double x, double y, double z, int combinedLight, EntityType<?> entityType) {
        float customEntityScale = this.getCustomEntityScale();
        this.renderCustomModel(poseStack, buffer, customEntityScale, x, y, z, combinedLight, entityType);
    }
}

