/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    private static final String PROCESS_TIME_TEXT = "Defines after how many seconds a loot drop is performed.";

    protected CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("{} Common config ...", (Object)"\ud83e\udea4 Register Bo's Easy Mob Farm");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue informOwnerAboutFullStorage;
        public final ForgeConfigSpec.BooleanValue logFullStorage;
        public final ForgeConfigSpec.IntValue lootPreviewRolls;
        public final ForgeConfigSpec.IntValue mobCatchingLuck;
        public final ForgeConfigSpec.IntValue animalPlainsFarmProcessTime;
        public final ForgeConfigSpec.IntValue creativeMobFarmProcessTime;
        public final ForgeConfigSpec.IntValue desertFarmProcessTime;
        public final ForgeConfigSpec.IntValue monsterPlainsCaveFarmProcessTime;
        public final ForgeConfigSpec.IntValue oceanFarmProcessTime;
        public final ForgeConfigSpec.BooleanValue blazeDropBlazeRod;
        public final ForgeConfigSpec.BooleanValue cowDropRawBeef;
        public final ForgeConfigSpec.BooleanValue chickenDropEggs;
        public final ForgeConfigSpec.BooleanValue chickenDropRawChicken;
        public final ForgeConfigSpec.BooleanValue sheepDropRawMutton;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Bo's Easy Mob Farm");
            builder.push("General");
            this.informOwnerAboutFullStorage = builder.comment("Enable/Disable owner messages about full storage to avoid lagging systems.").define("informOwnerAboutFullStorage", true);
            this.logFullStorage = builder.comment("Enable/Disable full storage log messages for the server logs.").define("logFullStorage", true);
            this.lootPreviewRolls = builder.comment("Number of roll's to get the loot preview for a captured mob. Higher numbers require more server load, but giving a more completed overview.").defineInRange("lootPreviewRolls", 2, 1, 5);
            builder.pop();
            builder.push("Mob Catching");
            this.mobCatchingLuck = builder.comment("Defines the luck of capturing the mob e.g. luck of 3 means a change of 1 to 3 to capture a mob. Higher numbers requires more luck. 0 = disable luck.").defineInRange("mobCatchingLuck", 3, 0, 100);
            builder.pop();
            builder.push("Animal Plains Farms");
            this.animalPlainsFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("animalPlainsFarmProcessTime", 300, 10, 3600);
            builder.pop();
            builder.push("CreativeMobFarm");
            this.creativeMobFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("creativeMobFarmProcessTime", 60, 10, 3600);
            builder.pop();
            builder.push("DesertFarm");
            this.desertFarmProcessTime = builder.comment("Defines after how many seconds a drop is performed.").defineInRange("desertFarmProcessTime", 300, 10, 3600);
            builder.pop();
            builder.push("MonsterPlainsCaveFarm");
            this.monsterPlainsCaveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("monsterPlainsCaveFarmProcessTime", 300, 10, 3600);
            builder.pop();
            builder.push("OceanFarm");
            this.oceanFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("oceanFarmProcessTime", 300, 10, 3600);
            builder.pop();
            builder.push("Blaze Settings");
            this.blazeDropBlazeRod = builder.comment("Enable/Disable blaze rod drops.").define("blazeDropBlazeRod", true);
            builder.pop();
            builder.push("Cow Settings");
            this.cowDropRawBeef = builder.comment("Enable/Disable cow raw beef drops.").define("cowDropRawBeef", true);
            builder.pop();
            builder.push("Chicken Settings");
            this.chickenDropEggs = builder.comment("Enable/Disable chicken egg drops.").define("chickenDropEggs", true);
            this.chickenDropRawChicken = builder.comment("Enable/Disable raw chicken drops.").define("chickenDropRawChicken", true);
            builder.pop();
            builder.push("Sheep Settings");
            this.sheepDropRawMutton = builder.comment("Enable/Disable sheep raw mutton drops.").define("sheepDropRawMutton", true);
            builder.pop();
        }
    }
}

