/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import de.markusbordihn.easymobfarm.loot.LootManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapturedMob
extends Item {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final String ENTITY_ID_TAG = "EntityId";
    private static final String ENTITY_LOOT_TABLE_TAG = "EntityLootTable";
    private static final String ENTITY_NAME_TAG = "EntityName";
    private static final String ENTITY_POSSIBLE_LOOT_TAG = "EntityPossibleLoot";
    private static final String ENTITY_PROCESSING_TIME_TAG = "EntityProcessingTime";
    private static final String ENTITY_TYPE_TAG = "EntityType";
    private static final String ENTITY_COLOR_TAG = "EntityColor";
    private static final String FALL_DISTANCE_TAG = "FallDistance";
    private static final String FIRE_TAG = "Fire";
    private static final String MOTION_TAG = "Motion";
    private static final String ON_GROUND_TAG = "OnGround";
    private static final int DEFAULT_FARM_PROCESSING_TIME = 6000;
    private Gson gson = new Gson();
    protected final Random random = new Random();

    public CapturedMob(Item.Properties properties) {
        super(properties);
    }

    public boolean hasCapturedMob(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        return compoundTag.m_128441_(ENTITY_NAME_TAG);
    }

    public List<String> getPossibleLoot(ItemStack itemStack) {
        String possibleLootString;
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_POSSIBLE_LOOT_TAG) && !(possibleLootString = compoundTag.m_128461_(ENTITY_POSSIBLE_LOOT_TAG)).isBlank()) {
            return (List)this.gson.fromJson(possibleLootString, ArrayList.class);
        }
        return Lists.newArrayList();
    }

    public String getCapturedMob(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_NAME_TAG)) {
            return compoundTag.m_128461_(ENTITY_NAME_TAG);
        }
        return "";
    }

    public Float getCapturedMobHealth(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_("Health")) {
            return Float.valueOf(compoundTag.m_128457_("Health"));
        }
        return Float.valueOf(5.0f);
    }

    public String getCapturedMobType(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_TYPE_TAG)) {
            return compoundTag.m_128461_(ENTITY_TYPE_TAG);
        }
        return "";
    }

    public EntityType<?> getCapturedMobEntityType(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_TYPE_TAG)) {
            String entityTypeName = compoundTag.m_128461_(ENTITY_TYPE_TAG);
            ResourceLocation resourceLocation = new ResourceLocation(entityTypeName);
            return (EntityType)Registry.f_122826_.m_7745_(resourceLocation);
        }
        return null;
    }

    public DyeColor getCapturedMobColor(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_COLOR_TAG)) {
            return DyeColor.m_41053_((int)compoundTag.m_128451_(ENTITY_COLOR_TAG));
        }
        return null;
    }

    public int getFarmProcessingTime(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_PROCESSING_TIME_TAG)) {
            return compoundTag.m_128451_(ENTITY_PROCESSING_TIME_TAG);
        }
        return 6000;
    }

    public String getLootTable(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_LOOT_TABLE_TAG)) {
            return compoundTag.m_128461_(ENTITY_LOOT_TABLE_TAG);
        }
        return "";
    }

    public ItemStack setCapturedMob(LivingEntity livingEntity, ItemStack itemStack) {
        log.debug("Capturing mob {} ...", (Object)livingEntity.m_7755_());
        CompoundTag entityData = livingEntity.serializeNBT();
        CompoundTag compoundTag = itemStack.m_41784_();
        String name = livingEntity.m_7755_().getString();
        String type = livingEntity.m_6095_().getRegistryName().toString();
        ResourceLocation lootTable = livingEntity.m_5743_();
        if (lootTable != null) {
            List<String> possibleLoot = LootManager.getRandomLootDropOverview(lootTable, livingEntity.m_183503_(), type);
            if (possibleLoot != null) {
                compoundTag.m_128359_(ENTITY_POSSIBLE_LOOT_TAG, this.gson.toJson(possibleLoot));
            }
            compoundTag.m_128359_(ENTITY_LOOT_TABLE_TAG, lootTable.toString());
        }
        livingEntity.m_146867_();
        if (entityData.m_128441_(FIRE_TAG) && entityData.m_128448_(FIRE_TAG) > 0) {
            entityData.m_128376_(FIRE_TAG, (short)0);
        }
        if (entityData.m_128441_(FALL_DISTANCE_TAG) && entityData.m_128457_(FALL_DISTANCE_TAG) > 0.0f) {
            entityData.m_128350_(FALL_DISTANCE_TAG, 0.0f);
        }
        if (entityData.m_128441_(MOTION_TAG)) {
            entityData.m_128365_(MOTION_TAG, (Tag)this.newDoubleList(0.0, 0.0, 0.0));
        }
        if (entityData.m_128441_(ON_GROUND_TAG) && !entityData.m_128471_(ON_GROUND_TAG)) {
            entityData.m_128379_(ON_GROUND_TAG, true);
        }
        compoundTag.m_128359_(ENTITY_NAME_TAG, name);
        compoundTag.m_128359_(ENTITY_TYPE_TAG, type);
        compoundTag.m_128359_(ENTITY_ID_TAG, livingEntity.m_20078_());
        if (livingEntity instanceof Sheep) {
            Sheep sheep = (Sheep)livingEntity;
            compoundTag.m_128405_(ENTITY_COLOR_TAG, sheep.m_29874_().m_41060_());
        }
        compoundTag.m_128391_(entityData);
        itemStack.m_41739_(compoundTag);
        log.debug("Stored following data in captured mob item stack: {}", (Object)compoundTag);
        livingEntity.m_142467_(Entity.RemovalReason.DISCARDED);
        return itemStack;
    }

    public boolean releaseCapturedMob(ItemStack itemStack, BlockPos blockPos, Level level) {
        Entity entity = this.getCapturedMobEntity(itemStack, level);
        if (entity != null) {
            BlockState blockState = level.m_8055_(blockPos);
            if (!(blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50037_))) {
                blockPos = blockPos.m_7494_();
                blockState = level.m_8055_(blockPos);
            }
            if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50037_)) {
                entity.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                log.debug("Release captured mob {} with {}", (Object)entity);
                return level.m_7967_(entity);
            }
        }
        return false;
    }

    public Entity getCapturedMobEntity(ItemStack itemStack, Level level) {
        CompoundTag compoundTag = itemStack.m_41784_();
        EntityType<?> entityType = this.getCapturedMobEntityType(itemStack);
        Entity entity = entityType.m_20615_(level);
        if (entity != null) {
            compoundTag.m_128473_(ENTITY_ID_TAG);
            compoundTag.m_128473_(ENTITY_LOOT_TABLE_TAG);
            compoundTag.m_128473_(ENTITY_NAME_TAG);
            compoundTag.m_128473_(ENTITY_POSSIBLE_LOOT_TAG);
            compoundTag.m_128473_(ENTITY_PROCESSING_TIME_TAG);
            compoundTag.m_128473_(ENTITY_TYPE_TAG);
            compoundTag.m_128473_(ENTITY_COLOR_TAG);
            entity.m_20258_(compoundTag);
            int damagedValue = itemStack.m_41773_();
            itemStack.m_41751_(new CompoundTag());
            itemStack.m_41721_(damagedValue);
        }
        return entity;
    }

    public boolean willItemBreak(ItemStack itemStack, int damage) {
        return itemStack.m_41773_() + damage >= itemStack.m_41776_();
    }

    public void damageItem(ItemStack itemStack, int damage) {
        int itemStackDamage = itemStack.m_41773_();
        if (itemStackDamage + damage >= itemStack.m_41776_()) {
            itemStack.m_41774_(1);
        } else {
            itemStack.m_41721_(itemStackDamage + damage);
        }
    }

    protected ListTag newDoubleList(double ... values) {
        ListTag listTag = new ListTag();
        for (double value : values) {
            listTag.add((Object)DoubleTag.m_128500_((double)value));
        }
        return listTag;
    }
}

