/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class LootManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static boolean blazeDropBlazeRod = (Boolean)LootManager.COMMON.blazeDropBlazeRod.get();
    private static boolean cowDropRawBeef = (Boolean)LootManager.COMMON.cowDropRawBeef.get();
    private static boolean chickenDropEggs = (Boolean)LootManager.COMMON.chickenDropEggs.get();
    private static boolean chickenDropRawChicken = (Boolean)LootManager.COMMON.chickenDropRawChicken.get();
    private static boolean sheepDropRawMutton = (Boolean)LootManager.COMMON.sheepDropRawMutton.get();
    private static int lootPreviewRolls = (Integer)LootManager.COMMON.lootPreviewRolls.get();
    private static FakePlayer fakePlayer;
    private static final GameProfile GAME_PROFILE;
    private static Map<ResourceLocation, List<String>> lootTableDropListCache;

    protected LootManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        blazeDropBlazeRod = (Boolean)LootManager.COMMON.blazeDropBlazeRod.get();
        cowDropRawBeef = (Boolean)LootManager.COMMON.cowDropRawBeef.get();
        chickenDropEggs = (Boolean)LootManager.COMMON.chickenDropEggs.get();
        chickenDropRawChicken = (Boolean)LootManager.COMMON.chickenDropRawChicken.get();
        sheepDropRawMutton = (Boolean)LootManager.COMMON.sheepDropRawMutton.get();
        lootPreviewRolls = (Integer)LootManager.COMMON.lootPreviewRolls.get();
        lootTableDropListCache = new ConcurrentHashMap<ResourceLocation, List<String>>();
    }

    public static FakePlayer getPlayer(ServerLevel level) {
        if (fakePlayer == null) {
            fakePlayer = new FakePlayer(level, GAME_PROFILE);
        }
        return fakePlayer;
    }

    public static List<String> getRandomLootDropOverview(ResourceLocation lootTableLocation, Level level, String mobType) {
        List<Object> lootDropList = Lists.newArrayList();
        for (int i = 0; i < lootPreviewRolls; ++i) {
            List<ItemStack> lootDrops = LootManager.getFilteredRandomLootDrop(lootTableLocation, level, mobType);
            lootDropList = LootManager.cacheLootDrops(lootTableLocation, lootDrops);
        }
        log.info("Loot for {} with {} roll {} result: {}", (Object)mobType, (Object)lootTableLocation, (Object)lootPreviewRolls, (Object)lootDropList);
        return lootDropList;
    }

    public static List<ItemStack> getRandomLootDrops(ResourceLocation lootTableLocation, Level level) {
        if (lootTableLocation == null || level == null || level.m_142572_() == null) {
            log.error("Unable to get loot drops for {} and {}", (Object)lootTableLocation, (Object)level);
            return Lists.newArrayList();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FakePlayer player = LootManager.getPlayer(serverLevel);
        LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_());
        builder.m_78963_(0.5f).m_78972_(LootContextParams.f_81455_, (Object)player).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19344_((Player)player));
        LootTable lootTable = level.m_142572_().m_129898_().m_79217_(lootTableLocation);
        List lootDrops = lootTable.m_79129_(builder.m_78975_(LootContextParamSets.f_81415_));
        if (lootDrops.isEmpty()) {
            log.warn("Loot drop for {} with loot table {} was empty!", (Object)player, (Object)lootTableLocation);
        }
        return lootDrops;
    }

    public static List<ItemStack> getFilteredRandomLootDrop(ItemStack itemStack, Level level) {
        CapturedMob capturedMobItem;
        ResourceLocation lootTable = null;
        String mobType = "";
        if (itemStack.m_41619_() || !(level instanceof ServerLevel)) {
            return Lists.newArrayList();
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            capturedMobItem = (CapturedMob)item;
            String lootTableLocation = capturedMobItem.getLootTable(itemStack);
            if (!lootTableLocation.isEmpty()) {
                lootTable = new ResourceLocation(lootTableLocation);
            }
        } else {
            log.error("Unable to process loot drop for {} in {}", (Object)itemStack, (Object)level);
            return Lists.newArrayList();
        }
        mobType = capturedMobItem.getCapturedMobType(itemStack);
        return LootManager.getFilteredRandomLootDrop(lootTable, level, mobType);
    }

    public static List<ItemStack> getFilteredRandomLootDrop(ResourceLocation lootTableLocation, Level level, String mobType) {
        List<ItemStack> lootDrops = LootManager.getRandomLootDrops(lootTableLocation, level);
        List<ItemStack> filteredLootDrops = LootManager.getFilteredLootDrop(lootDrops, mobType);
        LootManager.cacheLootDrops(lootTableLocation, filteredLootDrops);
        return filteredLootDrops;
    }

    public static List<ItemStack> getFilteredLootDrop(List<ItemStack> lootDrops, String mobType) {
        ArrayList filteredLootDrops = Lists.newArrayList();
        if (blazeDropBlazeRod && mobType.equals("minecraft:blaze")) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42585_));
        }
        if (chickenDropEggs && mobType.equals("minecraft:chicken")) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42521_));
        }
        for (ItemStack lootDrop : lootDrops) {
            if (lootDrop.m_41619_() || LootManager.filter(chickenDropRawChicken, "minecraft:chicken", Items.f_42581_, mobType, lootDrop) || LootManager.filter(cowDropRawBeef, "minecraft:cow", Items.f_42579_, mobType, lootDrop) || LootManager.filter(sheepDropRawMutton, "minecraft:sheep", Items.f_42658_, mobType, lootDrop)) continue;
            filteredLootDrops.add(lootDrop);
        }
        return filteredLootDrops;
    }

    public static boolean filter(boolean status, String blockedMobType, Item blockedLootDrop, String mobType, ItemStack lootDrop) {
        if (status) {
            return false;
        }
        return mobType.equals(blockedMobType) && lootDrop.m_150930_(blockedLootDrop);
    }

    private static List<String> cacheLootDrops(ResourceLocation lootTableLocation, List<ItemStack> lootDrops) {
        ArrayList lootDropList = Lists.newArrayList();
        List lootDropListCache = lootTableDropListCache.getOrDefault(lootTableLocation, null);
        if (lootDropListCache != null) {
            lootDropList.addAll(lootDropListCache);
        }
        for (ItemStack lootDrop : lootDrops) {
            lootDropList.add(lootDrop.m_41720_().m_5524_());
        }
        return lootTableDropListCache.put(lootTableLocation, lootDropList.stream().distinct().toList());
    }

    static {
        GAME_PROFILE = new GameProfile(UUID.randomUUID(), "[BOs_Easy_Mob_Farm]");
        lootTableDropListCache = new ConcurrentHashMap<ResourceLocation, List<String>>();
    }
}

