/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.minecraft.materialelements.block.multiplace;

import de.markusbordihn.minecraft.materialelements.block.multiplace.AdvancedMultiPlaceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TriangularBlock
extends AdvancedMultiPlaceBlock {
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape REAR_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape REAR_WEST_AABB = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape REAR_NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape REAR_EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_NORTH_AABB = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)REAR_NORTH_AABB);
    protected static final VoxelShape BOTTOM_EAST_AABB = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)REAR_EAST_AABB);
    protected static final VoxelShape BOTTOM_SOUTH_AABB = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)REAR_SOUTH_AABB);
    protected static final VoxelShape BOTTOM_WEST_AABB = Shapes.m_83110_((VoxelShape)BOTTOM_AABB, (VoxelShape)REAR_WEST_AABB);
    protected static final VoxelShape TOP_NORTH_AABB = Shapes.m_83110_((VoxelShape)TOP_AABB, (VoxelShape)REAR_NORTH_AABB);
    protected static final VoxelShape TOP_EAST_AABB = Shapes.m_83110_((VoxelShape)TOP_AABB, (VoxelShape)REAR_EAST_AABB);
    protected static final VoxelShape TOP_SOUTH_AABB = Shapes.m_83110_((VoxelShape)TOP_AABB, (VoxelShape)REAR_SOUTH_AABB);
    protected static final VoxelShape TOP_WEST_AABB = Shapes.m_83110_((VoxelShape)TOP_AABB, (VoxelShape)REAR_WEST_AABB);

    public TriangularBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        AttachFace attachFace = (AttachFace)blockState.m_61143_((Property)ATTACH_FACE);
        if (attachFace == AttachFace.FLOOR || attachFace == AttachFace.WALL) {
            switch ((Direction)blockState.m_61143_((Property)FACING)) {
                case EAST: {
                    return BOTTOM_EAST_AABB;
                }
                case SOUTH: {
                    return BOTTOM_SOUTH_AABB;
                }
                case WEST: {
                    return BOTTOM_WEST_AABB;
                }
            }
            return BOTTOM_NORTH_AABB;
        }
        switch ((Direction)blockState.m_61143_((Property)FACING)) {
            case EAST: {
                return TOP_EAST_AABB;
            }
            case SOUTH: {
                return TOP_SOUTH_AABB;
            }
            case WEST: {
                return TOP_WEST_AABB;
            }
        }
        return TOP_NORTH_AABB;
    }
}

