/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.minecraft.materialelements.block.multiplace;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiPlaceBlock
extends Block {
    protected static final Logger log = LogManager.getLogger((String)"Material Elements");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.f_61376_;
    protected static final VoxelShape FLOOR_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape CEILING_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FACING_EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FACING_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape FACING_NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FACING_WEST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public MultiPlaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(ATTACH_FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        AttachFace attachFace = (AttachFace)blockState.m_61143_(ATTACH_FACE);
        if (attachFace == AttachFace.CEILING) {
            return CEILING_AABB;
        }
        if (attachFace == AttachFace.FLOOR) {
            return FLOOR_AABB;
        }
        switch ((Direction)blockState.m_61143_((Property)FACING)) {
            case NORTH: {
                return FACING_NORTH_AABB;
            }
            case EAST: {
                return FACING_EAST_AABB;
            }
            case SOUTH: {
                return FACING_SOUTH_AABB;
            }
            case WEST: {
                return FACING_WEST_AABB;
            }
        }
        return FLOOR_AABB;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_142300_(direction.m_122424_()));
        Direction faceDirection = blockState.m_60713_((Block)this) && blockState.m_61143_((Property)FACING) == direction ? direction.m_122424_() : direction;
        AttachFace attachFace = AttachFace.FLOOR;
        if (faceDirection == Direction.DOWN) {
            attachFace = AttachFace.CEILING;
        } else if (faceDirection != Direction.UP) {
            attachFace = AttachFace.WALL;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACH_FACE, (Comparable)attachFace)).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.m_61104_(new Property[]{ATTACH_FACE, FACING});
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.DESTROY;
    }
}

