/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.minecraft.materialelements.block.rod;

import de.markusbordihn.minecraft.materialelements.block.rod.RodComplexBlock;
import de.markusbordihn.minecraft.materialelements.block.rod.RodHalfSize;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RodElbow
extends RodComplexBlock {
    protected static final Logger log = LogManager.getLogger((String)"Material Elements");
    protected static final VoxelShape CENTER_AABB = Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    protected static final VoxelShape FLOOR_NORTH_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.FLOOR_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_WEST_AABB, CENTER_AABB});
    protected static final VoxelShape FLOOR_EAST_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.FLOOR_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_NORTH_AABB, CENTER_AABB});
    protected static final VoxelShape FLOOR_SOUTH_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.FLOOR_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_EAST_AABB, CENTER_AABB});
    protected static final VoxelShape FLOOR_WEST_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.FLOOR_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_SOUTH_AABB, CENTER_AABB});
    protected static final VoxelShape WALL_NORTH_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.WALL_WEST_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_NORTH_AABB, CENTER_AABB});
    protected static final VoxelShape WALL_EAST_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.WALL_NORTH_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_EAST_AABB, CENTER_AABB});
    protected static final VoxelShape WALL_SOUTH_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.WALL_EAST_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_SOUTH_AABB, CENTER_AABB});
    protected static final VoxelShape WALL_WEST_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.WALL_SOUTH_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_WEST_AABB, CENTER_AABB});
    protected static final VoxelShape CEILING_NORTH_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.CEILING_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_WEST_AABB, CENTER_AABB});
    protected static final VoxelShape CEILING_EAST_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.CEILING_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_NORTH_AABB, CENTER_AABB});
    protected static final VoxelShape CEILING_SOUTH_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.CEILING_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_EAST_AABB, CENTER_AABB});
    protected static final VoxelShape CEILING_WEST_AABB = Shapes.m_83124_((VoxelShape)RodHalfSize.CEILING_AABB, (VoxelShape[])new VoxelShape[]{RodHalfSize.WALL_SOUTH_AABB, CENTER_AABB});

    public RodElbow(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean hasUnwantedBuilds(Level level, BlockPos blockPos) {
        BlockPos blockPosNorth = blockPos.m_142127_();
        BlockPos blockPosEast = blockPos.m_142126_();
        BlockPos blockPosSouth = blockPos.m_142128_();
        BlockPos blockPosWest = blockPos.m_142125_();
        BlockState blockStateNorth = level.m_8055_(blockPosNorth);
        BlockState blockStateEast = level.m_8055_(blockPosEast);
        BlockState blockStateSouth = level.m_8055_(blockPosSouth);
        BlockState blockStateWest = level.m_8055_(blockPosWest);
        if (!(blockStateNorth.m_60734_() instanceof RodElbow && blockStateEast.m_60734_() instanceof RodElbow && blockStateSouth.m_60734_() instanceof RodElbow && blockStateWest.m_60734_() instanceof RodElbow)) {
            return false;
        }
        return blockStateNorth.m_61143_((Property)RodComplexBlock.FACING) == Direction.NORTH && blockStateEast.m_61143_((Property)RodComplexBlock.FACING) == Direction.EAST && blockStateSouth.m_61143_((Property)RodComplexBlock.FACING) == Direction.SOUTH && blockStateWest.m_61143_((Property)RodComplexBlock.FACING) == Direction.WEST || blockStateNorth.m_61143_((Property)RodComplexBlock.FACING) == Direction.EAST && blockStateEast.m_61143_((Property)RodComplexBlock.FACING) == Direction.SOUTH && blockStateSouth.m_61143_((Property)RodComplexBlock.FACING) == Direction.WEST && blockStateWest.m_61143_((Property)RodComplexBlock.FACING) == Direction.NORTH || blockStateNorth.m_61143_((Property)RodComplexBlock.FACING) == Direction.SOUTH && blockStateEast.m_61143_((Property)RodComplexBlock.FACING) == Direction.WEST && blockStateSouth.m_61143_((Property)RodComplexBlock.FACING) == Direction.NORTH && blockStateWest.m_61143_((Property)RodComplexBlock.FACING) == Direction.EAST || blockStateNorth.m_61143_((Property)RodComplexBlock.FACING) == Direction.WEST && blockStateEast.m_61143_((Property)RodComplexBlock.FACING) == Direction.NORTH && blockStateSouth.m_61143_((Property)RodComplexBlock.FACING) == Direction.EAST && blockStateWest.m_61143_((Property)RodComplexBlock.FACING) == Direction.SOUTH;
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        AttachFace attachFace = (AttachFace)blockState.m_61143_(RodComplexBlock.ATTACH_FACE);
        Direction facing = (Direction)blockState.m_61143_((Property)RodComplexBlock.FACING);
        if (attachFace == AttachFace.FLOOR) {
            switch (facing) {
                case EAST: {
                    return FLOOR_EAST_AABB;
                }
                case SOUTH: {
                    return FLOOR_SOUTH_AABB;
                }
                case WEST: {
                    return FLOOR_WEST_AABB;
                }
            }
            return FLOOR_NORTH_AABB;
        }
        if (attachFace == AttachFace.WALL) {
            switch (facing) {
                case EAST: {
                    return WALL_EAST_AABB;
                }
                case SOUTH: {
                    return WALL_SOUTH_AABB;
                }
                case WEST: {
                    return WALL_WEST_AABB;
                }
            }
            return WALL_NORTH_AABB;
        }
        if (attachFace == AttachFace.CEILING) {
            switch (facing) {
                case EAST: {
                    return CEILING_EAST_AABB;
                }
                case SOUTH: {
                    return CEILING_SOUTH_AABB;
                }
                case WEST: {
                    return CEILING_WEST_AABB;
                }
            }
            return CEILING_NORTH_AABB;
        }
        return RodComplexBlock.DEFAULT_SHAPE_AABB;
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean status) {
        if (blockState.m_61143_(RodComplexBlock.ATTACH_FACE) != AttachFace.WALL) {
            return;
        }
        if (RodElbow.hasUnwantedBuilds(level, blockPos.m_142127_()) || RodElbow.hasUnwantedBuilds(level, blockPos.m_142126_()) || RodElbow.hasUnwantedBuilds(level, blockPos.m_142128_()) || RodElbow.hasUnwantedBuilds(level, blockPos.m_142125_())) {
            level.m_46961_(blockPos, true);
            log.warn("Found unwanted builds at {} which was destroyed", (Object)blockPos);
        }
    }
}

