/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.block.entity.farm.CreativeMobFarmEntity;
import de.markusbordihn.easymobfarm.config.biome.Plains;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreativeMobFarm
extends MobFarmBlock {
    public static final String NAME = "creative_mob_farm";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final Set<String> acceptedMobTypes = Plains.Passive;

    public CreativeMobFarm(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static boolean isAcceptedCapturedMobType(String mobType) {
        return acceptedMobTypes.contains(mobType);
    }

    public static int getLightLevel(BlockState blockState) {
        return 15;
    }

    @Override
    public Set<String> getAcceptedMobTypes() {
        return null;
    }

    @Override
    public boolean isAcceptedMobType(String mobType) {
        return mobType != null && !mobType.isBlank();
    }

    @Override
    public String getFarmDescriptionId() {
        return "supported_creative";
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CreativeMobFarmEntity((BlockEntityType)ModBlocks.CREATIVE_MOB_FARM_ENTITY.get(), blockPos, blockState);
    }

    @Override
    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof CreativeMobFarmEntity) {
            CreativeMobFarmEntity creativeMobFarmEntity = (CreativeMobFarmEntity)blockEntity;
            player.m_5893_((MenuProvider)creativeMobFarmEntity);
        }
    }

    @Override
    public InteractionResult consumeCapturedMob(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack, UseOnContext context) {
        CreativeMobFarmEntity creativeMobFarmEntity = (CreativeMobFarmEntity)blockEntity;
        creativeMobFarmEntity.updateLevel(level);
        if (!creativeMobFarmEntity.hasItem(0)) {
            creativeMobFarmEntity.m_6836_(0, itemStack);
            Player player = context.m_43723_();
            if (player != null) {
                player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : CreativeMobFarm.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.CREATIVE_MOB_FARM_ENTITY.get()), MobFarmBlockEntity::serverTick);
    }
}

