/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntityData;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import de.markusbordihn.easymobfarm.loot.LootManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class MobFarmBlockEntity
extends MobFarmBlockEntityData
implements WorldlyContainer {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final int DEFAULT_FARM_PROCESSING_TIME = 6000;
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static boolean informOwnerAboutFullStorage = (Boolean)MobFarmBlockEntity.COMMON.informOwnerAboutFullStorage.get();
    private static boolean logFullStorage = (Boolean)MobFarmBlockEntity.COMMON.logFullStorage.get();
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN});

    public MobFarmBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(null, blockPos, blockState);
    }

    public MobFarmBlockEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        informOwnerAboutFullStorage = (Boolean)MobFarmBlockEntity.COMMON.informOwnerAboutFullStorage.get();
        logFullStorage = (Boolean)MobFarmBlockEntity.COMMON.logFullStorage.get();
    }

    public void updateLevel(Level level) {
        if (this.f_58857_ == null && this.f_58857_ != level && !level.m_5776_()) {
            this.f_58857_ = level;
        }
    }

    public boolean hasItem(int index) {
        return !((ItemStack)this.items.get(index)).m_41619_();
    }

    public boolean allowLootDropItem(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_();
    }

    public void givePlayerItem(int index, Level level, Player player, InteractionHand hand, BlockPos blockPos) {
        ItemStack itemStack = this.takeItem(index);
        if (itemStack.m_41619_() || itemStack.m_41773_() >= itemStack.m_41776_()) {
            return;
        }
        ItemStack handItemStack = player.m_21120_(hand);
        if (handItemStack.m_41619_()) {
            player.m_21008_(hand, itemStack);
        } else if (!player.m_150109_().m_36054_(itemStack) && level != null) {
            level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack));
        }
        this.syncData();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, MobFarmBlockEntity blockEntity) {
        ItemStack capturedMob = (ItemStack)blockEntity.items.get(0);
        if (capturedMob.m_41619_() || !blockEntity.hasItem(0)) {
            blockEntity.farmProgress = 0;
            blockEntity.farmStatus = 2;
            return;
        }
        ItemStack resultItem1 = (ItemStack)blockEntity.items.get(1);
        ItemStack resultItem2 = (ItemStack)blockEntity.items.get(2);
        ItemStack resultItem3 = (ItemStack)blockEntity.items.get(3);
        ItemStack resultItem4 = (ItemStack)blockEntity.items.get(4);
        ItemStack resultItem5 = (ItemStack)blockEntity.items.get(5);
        if (resultItem1.m_41613_() >= resultItem1.m_41741_() && resultItem2.m_41613_() >= resultItem2.m_41741_() && resultItem3.m_41613_() >= resultItem3.m_41741_() && resultItem4.m_41613_() >= resultItem4.m_41741_() && resultItem5.m_41613_() >= resultItem5.m_41741_()) {
            if (blockEntity.farmStatus != 1) {
                blockEntity.farmStatus = 1;
            }
            return;
        }
        if (blockEntity.farmProgress >= blockEntity.farmTotalTime) {
            if (capturedMob.m_41720_() instanceof CapturedMob || CapturedMobVirtual.isSupported(capturedMob)) {
                blockEntity.processResult(capturedMob, blockEntity);
                blockEntity.processAdditionalEffects(level, blockPos, blockEntity, capturedMob);
            }
            blockEntity.farmProgress = 0;
            blockEntity.farmStatus = 0;
        } else {
            ++blockEntity.farmProgress;
            blockEntity.farmStatus = 3;
        }
    }

    private void processResult(ItemStack capturedMob, MobFarmBlockEntity blockEntity) {
        List<ItemStack> lootDrops = LootManager.getFilteredRandomLootDrop(capturedMob, blockEntity.m_58904_());
        ArrayList<ItemStack> unstoredLootDrops = new ArrayList<ItemStack>();
        log.debug("Processing result with {}", lootDrops);
        for (ItemStack lootDrop : lootDrops) {
            if (lootDrop.m_41619_() || !this.allowLootDropItem(lootDrop)) continue;
            ItemStack resultItem1 = (ItemStack)blockEntity.items.get(1);
            if (!resultItem1.m_41619_() && resultItem1.m_150930_(lootDrop.m_41720_()) && resultItem1.m_41613_() + lootDrop.m_41613_() <= resultItem1.m_41741_()) {
                resultItem1.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem2 = (ItemStack)blockEntity.items.get(2);
            if (!resultItem2.m_41619_() && resultItem2.m_150930_(lootDrop.m_41720_()) && resultItem2.m_41613_() + lootDrop.m_41613_() <= resultItem2.m_41741_()) {
                resultItem2.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem3 = (ItemStack)blockEntity.items.get(3);
            if (!resultItem3.m_41619_() && resultItem3.m_150930_(lootDrop.m_41720_()) && resultItem3.m_41613_() + lootDrop.m_41613_() <= resultItem3.m_41741_()) {
                resultItem3.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem4 = (ItemStack)blockEntity.items.get(4);
            if (!resultItem4.m_41619_() && resultItem4.m_150930_(lootDrop.m_41720_()) && resultItem4.m_41613_() + lootDrop.m_41613_() <= resultItem4.m_41741_()) {
                resultItem4.m_41769_(lootDrop.m_41613_());
                continue;
            }
            ItemStack resultItem5 = (ItemStack)blockEntity.items.get(5);
            if (!resultItem5.m_41619_() && resultItem5.m_150930_(lootDrop.m_41720_()) && resultItem5.m_41613_() + lootDrop.m_41613_() <= resultItem5.m_41741_()) {
                resultItem5.m_41769_(lootDrop.m_41613_());
                continue;
            }
            if (resultItem1.m_41619_()) {
                blockEntity.m_6836_(1, lootDrop);
                continue;
            }
            if (resultItem2.m_41619_()) {
                blockEntity.m_6836_(2, lootDrop);
                continue;
            }
            if (resultItem3.m_41619_()) {
                blockEntity.m_6836_(3, lootDrop);
                continue;
            }
            if (resultItem4.m_41619_()) {
                blockEntity.m_6836_(4, lootDrop);
                continue;
            }
            if (resultItem5.m_41619_()) {
                blockEntity.m_6836_(5, lootDrop);
                continue;
            }
            unstoredLootDrops.add(lootDrop);
        }
        if (!unstoredLootDrops.isEmpty()) {
            this.processFullStorage(blockEntity, unstoredLootDrops);
        }
        this.syncData();
    }

    public void processAdditionalEffects(Level level, BlockPos blockPos, MobFarmBlockEntity blockEntity, ItemStack capturedMob) {
    }

    public void processFullStorage(MobFarmBlockEntity blockEntity, List<ItemStack> lootDrop) {
        Player owner;
        if (!informOwnerAboutFullStorage && !logFullStorage) {
            return;
        }
        UUID ownerUUID = blockEntity.getOwner();
        BlockPos blockPos = blockEntity.m_58899_();
        if (logFullStorage) {
            log.warn("Unable to store loot drop {} for mob farm {} at {} for owner {}!", lootDrop, (Object)this.farmMobName, (Object)blockPos, (Object)ownerUUID);
        }
        Level level = blockEntity.f_58857_;
        if (informOwnerAboutFullStorage && ownerUUID != null && level != null && (owner = level.m_46003_(ownerUUID)) != null && owner.m_6084_()) {
            MutableComponent message = new TranslatableComponent("message.easy_mob_farm.warning_full", new Object[]{this.farmMobName, blockPos, lootDrop}).m_130940_(ChatFormatting.YELLOW);
            owner.m_6352_((Component)message, null);
        }
    }

    @Override
    public void m_6836_(int index, ItemStack itemStack) {
        super.m_6836_(index, itemStack);
        if (index == 0) {
            if (itemStack.m_41720_() instanceof CapturedMob) {
                this.farmMobName = CapturedMob.getCapturedMob(itemStack);
                this.farmMobType = CapturedMob.getCapturedMobType(itemStack);
                this.farmMobColor = CapturedMob.getCapturedMobColor(itemStack);
                this.farmMobEntityType = CapturedMob.getCapturedMobEntityType(itemStack);
            } else if (CapturedMobVirtual.isSupported(itemStack)) {
                this.farmMobName = CapturedMobVirtual.getCapturedMob(itemStack);
                this.farmMobType = CapturedMobVirtual.getCapturedMobType(itemStack);
                this.farmMobColor = CapturedMobVirtual.getCapturedMobColor(itemStack);
                this.farmMobEntityType = CapturedMobVirtual.getCapturedMobEntityType(itemStack);
            } else {
                this.farmMobName = "";
                this.farmMobType = "";
                this.farmMobColor = null;
                this.farmMobEntityType = null;
            }
            if (this.farmMobType != null && !this.farmMobType.isBlank()) {
                this.farmTotalTime = this.getFarmProcessingTime() > 0 ? this.getFarmProcessingTime() : 6000;
                log.debug("Farm Processing time {}", (Object)this.farmTotalTime);
            }
            BlockState blockState = this.m_58900_();
            BlockPos blockPos = this.m_58899_();
            Level level = this.f_58857_;
            if (blockState != null && blockPos != null && level != null) {
                BlockState newBlockState = (BlockState)blockState.m_61124_((Property)MobFarmBlock.WORKING, (Comparable)Boolean.valueOf(!itemStack.m_41619_()));
                level.m_7731_(blockPos, newBlockState, 3);
                MobFarmBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)newBlockState);
            }
            this.syncData();
        }
    }

    @Override
    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = super.m_7407_(index, count);
        if (index == 0) {
            this.syncData();
        }
        return itemStack;
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return new int[]{1, 2, 3, 4, 5};
        }
        return new int[0];
    }

    public boolean m_7155_(int slotIndex, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int slotIndex, ItemStack itemStack, Direction direction) {
        return direction == Direction.DOWN && (slotIndex == 1 || slotIndex == 2 || slotIndex == 3 || slotIndex == 4 || slotIndex == 5);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }
}

