/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity;

import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;

public class MobFarmBlockEntityData
extends BaseContainerBlockEntity {
    public static final int FARM_TIME_DATA = 0;
    public static final int FARM_DURATION_DATA = 1;
    public static final int FARM_PROGRESS_DATA = 2;
    public static final int FARM_TOTAL_TIME_DATA = 3;
    public static final int FARM_STATUS_DATA = 4;
    public static final int FARM_MOB_NAME_DATA = 5;
    public static final int DATA_SIZE = 6;
    public static final String FARM_DURATION_TAG = "FarmDuration";
    public static final String FARM_TIME_TAG = "FarmTime";
    public static final String FARM_PROGRESS_TAG = "FarmProgress";
    public static final String FARM_TIME_TOTAL_TAG = "FarmTimeTotal";
    public static final String FARM_OWNER_TAG = "FarmOwner";
    public static final int FARM_STATUS_DONE = 0;
    public static final int FARM_STATUS_FULL = 1;
    public static final int FARM_STATUS_WAITING = 2;
    public static final int FARM_STATUS_WORKING = 3;
    public UUID farmOwner;
    public int farmDuration;
    public int farmProgress;
    public int farmStatus;
    public int farmTime = -1;
    public int farmTotalTime;
    public int farmId;
    public String farmMobName = "";
    public String farmMobType = "";
    public DyeColor farmMobColor = null;
    public EntityType<?> farmMobEntityType = null;
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return MobFarmBlockEntityData.this.farmTime;
                }
                case 1: {
                    return MobFarmBlockEntityData.this.farmDuration;
                }
                case 2: {
                    return MobFarmBlockEntityData.this.farmProgress;
                }
                case 3: {
                    return MobFarmBlockEntityData.this.farmTotalTime;
                }
                case 4: {
                    return MobFarmBlockEntityData.this.farmStatus;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MobFarmBlockEntityData.this.farmTime = value;
                    break;
                }
                case 1: {
                    MobFarmBlockEntityData.this.farmDuration = value;
                    break;
                }
                case 2: {
                    MobFarmBlockEntityData.this.farmProgress = value;
                    break;
                }
                case 3: {
                    MobFarmBlockEntityData.this.farmTotalTime = value;
                    break;
                }
                case 4: {
                    MobFarmBlockEntityData.this.farmStatus = value;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    public MobFarmBlockEntityData(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
        this.farmId = blockPos.hashCode();
    }

    public void setOwner(LivingEntity livingEntity) {
        this.farmOwner = livingEntity.m_142081_();
        this.m_6596_();
    }

    public UUID getOwner() {
        return this.farmOwner;
    }

    public int getFarmId() {
        return this.farmId;
    }

    public String getFarmMobType() {
        return this.farmMobType;
    }

    public DyeColor getFarmMobColor() {
        return this.farmMobColor;
    }

    public EntityType<?> getFarmMobEntityType() {
        return this.farmMobEntityType;
    }

    public int getFarmProcessingTime() {
        return 0;
    }

    public ItemStack takeItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.m_8020_(index);
        this.m_6836_(index, ItemStack.f_41583_);
        return itemStack;
    }

    public void syncData() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        this.m_6596_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (chunkSource = (chunk = (serverLevel = (ServerLevel)level).m_46745_(this.m_58899_())).m_62953_().m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverChunkCache = (ServerChunkCache)chunkSource;
            serverChunkCache.f_8325_.m_183262_(chunk.m_7697_(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.f_8906_.m_141995_(this.m_183216_());
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.easy_mob_farm");
    }

    public boolean m_6542_(Player player) {
        Level level = this.f_58857_;
        return level != null && level.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public void m_6836_(int index, ItemStack itemStack) {
        ItemStack itemStackFromIndex = (ItemStack)this.items.get(index);
        if (itemStack.m_41656_(itemStackFromIndex)) {
            return;
        }
        this.items.set(index, (Object)itemStack);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public void m_6211_() {
        this.items.clear();
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new MobFarmMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket dataPacket) {
        this.handleUpdateTag(dataPacket.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag updateCompoundTag = new CompoundTag();
        this.m_183515_(updateCompoundTag);
        return updateCompoundTag;
    }

    public void m_142466_(CompoundTag compoundTag) {
        ItemStack capturedMob;
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        this.farmDuration = compoundTag.m_128451_(FARM_DURATION_TAG);
        this.farmTime = compoundTag.m_128451_(FARM_TIME_TAG);
        this.farmProgress = compoundTag.m_128451_(FARM_PROGRESS_TAG);
        this.farmTotalTime = compoundTag.m_128451_(FARM_TIME_TOTAL_TAG);
        if (this.getFarmProcessingTime() > 0 && this.farmTotalTime > 0 && this.getFarmProcessingTime() != this.farmTotalTime) {
            this.farmTotalTime = this.getFarmProcessingTime();
            if (this.farmProgress > this.farmTotalTime) {
                this.farmProgress = this.farmTotalTime;
            }
        }
        if (compoundTag.m_128403_(FARM_OWNER_TAG)) {
            this.farmOwner = compoundTag.m_128342_(FARM_OWNER_TAG);
        }
        if (!(capturedMob = (ItemStack)this.items.get(0)).m_41619_()) {
            if (capturedMob.m_41720_() instanceof CapturedMob) {
                this.farmMobName = CapturedMob.getCapturedMob(capturedMob);
                this.farmMobType = CapturedMob.getCapturedMobType(capturedMob);
                this.farmMobColor = CapturedMob.getCapturedMobColor(capturedMob);
                this.farmMobEntityType = CapturedMob.getCapturedMobEntityType(capturedMob);
            } else if (CapturedMobVirtual.isSupported(capturedMob)) {
                this.farmMobName = CapturedMobVirtual.getCapturedMob(capturedMob);
                this.farmMobType = CapturedMobVirtual.getCapturedMobType(capturedMob);
                this.farmMobColor = CapturedMobVirtual.getCapturedMobColor(capturedMob);
                this.farmMobEntityType = CapturedMobVirtual.getCapturedMobEntityType(capturedMob);
            }
        }
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_(FARM_DURATION_TAG, this.farmDuration);
        compoundTag.m_128405_(FARM_TIME_TAG, this.farmTime);
        compoundTag.m_128405_(FARM_PROGRESS_TAG, this.farmProgress);
        compoundTag.m_128405_(FARM_TIME_TOTAL_TAG, this.farmTotalTime);
        if (this.farmOwner != null) {
            compoundTag.m_128362_(FARM_OWNER_TAG, this.farmOwner);
        }
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
    }
}

