/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity.farm;

import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.menu.farm.NetherFortressFarmMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class NetherFortressFarmEntity
extends MobFarmBlockEntity {
    private static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int netherFortressFarmProcessTime = (Integer)NetherFortressFarmEntity.COMMON.netherFortressFarmProcessTime.get();
    private static int farmProcessingTime = netherFortressFarmProcessTime * 20;

    public NetherFortressFarmEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.NETHER_FORTRESS_FARM_ENTITY.get(), blockPos, blockState);
    }

    public NetherFortressFarmEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        netherFortressFarmProcessTime = (Integer)NetherFortressFarmEntity.COMMON.netherFortressFarmProcessTime.get();
        farmProcessingTime = netherFortressFarmProcessTime * 20;
        log.info("{}: NetherFortressFarm Entity with drops every {}s", (Object)"\ud83e\udea4 Configure Bo's Easy Mob Farm", (Object)netherFortressFarmProcessTime);
    }

    @Override
    protected Component m_6820_() {
        return new TranslatableComponent("container.easy_mob_farm.nether_fortress_farm");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return new NetherFortressFarmMenu(windowId, inventory, (Container)this, this.dataAccess);
    }

    @Override
    public int getFarmProcessingTime() {
        return farmProcessingTime;
    }

    @Override
    public void processAdditionalEffects(Level level, BlockPos blockPos, MobFarmBlockEntity blockEntity, ItemStack capturedMob) {
        super.processAdditionalEffects(level, blockPos, blockEntity, capturedMob);
        level.m_5594_(null, blockPos, SoundEvents.f_12007_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

