/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.markusbordihn.easymobfarm.client.renderer.helper.RenderModels;
import de.markusbordihn.easymobfarm.client.screen.Snapshots;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final ResourceLocation TEXTURE = new ResourceLocation("easy_mob_farm", "textures/container/mob_farm_gui.png");
    private static final ResourceLocation CUSTOM = new ResourceLocation("easy_mob_farm", "textures/container/custom.png");
    private static final ResourceLocation CUSTOM_SHADOW = new ResourceLocation("easy_mob_farm", "textures/container/custom_shadow.png");
    public static final int SNAP_WITH = 34;
    public static final int SNAP_HEIGHT = 53;
    private MobFarmMenu mobFarmMenu;
    private RenderModels renderModels;
    private TranslatableComponent warningFullText;
    private float dropTimeLabelScale = 0.75f;
    private float nextDropTimeLabelScale = 1.0f;
    private int dropTimeLabelX;
    private int dropTimeLabelY;
    private int nextDropTimeLabelX;
    private int nextDropTimeLabelY;
    private int ticker = 0;
    public ResourceLocation backgroundTexture = TEXTURE;

    public MobFarmScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.mobFarmMenu = (MobFarmMenu)((Object)menu);
    }

    protected void renderSnapshot(PoseStack poseStack, ResourceLocation mobFarmTypeSnapshot) {
        if (mobFarmTypeSnapshot != null) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)mobFarmTypeSnapshot);
            MobFarmScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 6), (int)(this.f_97736_ + 22), (float)0.0f, (float)0.0f, (int)34, (int)53, (int)34, (int)53);
        }
    }

    private void renderEntityType(PoseStack poseStack, int x, int y) {
        String mobFarmType = this.mobFarmMenu.getMobFarmType();
        if (!mobFarmType.isBlank() && this.mobFarmMenu.getMobFarmStatus() != 2) {
            ResourceLocation mobFarmTypeSnapshot = Snapshots.getSnapshot(mobFarmType);
            if (mobFarmTypeSnapshot != null) {
                this.renderSnapshot(poseStack, mobFarmTypeSnapshot);
            } else {
                LivingEntity livingEntity = this.renderModels.getEntityTypeModel(mobFarmType);
                if (livingEntity != null) {
                    this.renderSnapshot(poseStack, CUSTOM_SHADOW);
                    this.renderEntity(this.f_97735_ + 23, this.f_97736_ + 67, (float)this.f_97735_ + 23.0f - (float)x, (float)this.f_97736_ + 67.0f - (float)y, livingEntity);
                } else {
                    this.renderSnapshot(poseStack, CUSTOM);
                }
            }
        }
    }

    private void renderEntity(int x, int y, float yRot, float xRot, LivingEntity livingEntity) {
        float f = (float)Math.atan(yRot / 40.0f);
        float f1 = (float)Math.atan(xRot / 40.0f);
        int scale = 19;
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack1 = new PoseStack();
        poseStack1.m_85837_(0.0, 0.0, 1000.0);
        poseStack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(f1 * 20.0f);
        quaternion.m_80148_(quaternion1);
        poseStack1.m_85845_(quaternion);
        float entityYBodyRot = livingEntity.f_20883_;
        float entityYRot = livingEntity.m_146908_();
        float entityXRot = livingEntity.m_146909_();
        float entityYHeadRotO = livingEntity.f_20886_;
        float entityYHeadRot = livingEntity.f_20885_;
        livingEntity.f_20883_ = 180.0f + f * 20.0f;
        livingEntity.m_146922_(180.0f + f * 40.0f);
        livingEntity.m_146926_(-f1 * 20.0f);
        livingEntity.f_20885_ = livingEntity.m_146908_();
        Component customName = livingEntity.m_7770_();
        livingEntity.m_6593_(null);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        entityRenderDispatcher.m_114412_(quaternion1);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multiBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack1, (MultiBufferSource)multiBuffer, 0xF000F0);
        multiBuffer.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        livingEntity.f_20883_ = entityYBodyRot;
        livingEntity.m_146922_(entityYRot);
        livingEntity.m_146926_(entityXRot);
        livingEntity.f_20885_ = entityYHeadRot;
        livingEntity.f_20886_ = entityYHeadRotO;
        livingEntity.m_6593_(customName);
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public void m_7856_() {
        super.m_7856_();
        this.ticker = 0;
        this.f_97727_ = 180;
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97731_ = this.f_97727_ - 93;
        this.dropTimeLabelX = Math.round(45.0f / this.dropTimeLabelScale);
        this.dropTimeLabelY = Math.round(78.0f / this.dropTimeLabelScale);
        this.nextDropTimeLabelX = Math.round(65.0f / this.nextDropTimeLabelScale);
        this.nextDropTimeLabelY = Math.round(45.0f / this.nextDropTimeLabelScale);
        this.warningFullText = new TranslatableComponent("text.easy_mob_farm.warning_full");
        this.renderModels = new RenderModels(this.f_96541_);
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        if ((this.ticker++ & 0x27) == 0) {
            this.mobFarmMenu.updateMobFarmDataCache();
            if (this.ticker >= 40) {
                this.ticker = 0;
            }
        }
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        this.renderEntityType(poseStack, x, y);
        this.m_7025_(poseStack, x, y);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        super.m_7027_(poseStack, x, y);
        int mobFarmStatus = this.mobFarmMenu.getMobFarmStatus();
        if (mobFarmStatus != 1) {
            poseStack.m_85836_();
            poseStack.m_85841_(this.dropTimeLabelScale, this.dropTimeLabelScale, this.dropTimeLabelScale);
            this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("text.easy_mob_farm.drop_time_secs", new Object[]{this.mobFarmMenu.getMobFarmTotalTime() / 20}), (float)this.dropTimeLabelX, (float)this.dropTimeLabelY, 0xAAAAAA);
            poseStack.m_85849_();
        }
        if (mobFarmStatus != 2) {
            poseStack.m_85836_();
            this.f_96547_.m_92883_(poseStack, this.mobFarmMenu.getMobFarmName(), 65.0f, 23.0f, 43520);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            this.f_96547_.m_92883_(poseStack, this.mobFarmMenu.getMobFarmType(), 100.0f, 50.0f, 0xAAAAAA);
            poseStack.m_85849_();
        }
        switch (mobFarmStatus) {
            case 0: 
            case 3: {
                poseStack.m_85836_();
                poseStack.m_85841_(this.nextDropTimeLabelScale, this.nextDropTimeLabelScale, this.nextDropTimeLabelScale);
                this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("text.easy_mob_farm.next_drop_secs", new Object[]{this.mobFarmMenu.getMobFarmRemainingTime()}), (float)this.nextDropTimeLabelX, (float)this.nextDropTimeLabelY, 0);
                poseStack.m_85849_();
                break;
            }
            case 1: {
                poseStack.m_85836_();
                poseStack.m_85841_(this.dropTimeLabelScale, this.dropTimeLabelScale, this.dropTimeLabelScale);
                this.f_96547_.m_92889_(poseStack, (Component)this.warningFullText, (float)this.dropTimeLabelX, (float)this.dropTimeLabelY, 0xFF5555);
                poseStack.m_85849_();
                break;
            }
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.backgroundTexture);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        switch (this.mobFarmMenu.getMobFarmStatus()) {
            case 0: 
            case 3: {
                int mobFarmProgress = this.mobFarmMenu.getMobFarmProgressImage();
                int mobFarmProgressLeftPos = this.f_97735_ + 43;
                int mobFarmProgressTopPos = this.f_97736_ + 41;
                this.m_93228_(poseStack, mobFarmProgressLeftPos, mobFarmProgressTopPos, 194, 14, 18, mobFarmProgress);
                break;
            }
            case 1: {
                int mobFarmFullLeftPos = this.f_97735_ + 43;
                int mobFarmFullTopPos = this.f_97736_ + 41;
                this.m_93228_(poseStack, mobFarmFullLeftPos, mobFarmFullTopPos, 176, 14, 18, 15);
                break;
            }
            case 2: {
                int mobFarmHintLeftPos = this.f_97735_ + 65;
                int mobFarmHintTopPos = this.f_97736_ + 21;
                this.m_93228_(poseStack, mobFarmHintLeftPos, mobFarmHintTopPos, 220, 14, 20, 15);
                break;
            }
        }
    }
}

