/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.biome.Desert;
import de.markusbordihn.easymobfarm.config.biome.Jungle;
import de.markusbordihn.easymobfarm.config.biome.Ocean;
import de.markusbordihn.easymobfarm.config.biome.Plains;
import de.markusbordihn.easymobfarm.config.biome.PlainsCave;
import de.markusbordihn.easymobfarm.config.biome.Swamp;
import de.markusbordihn.easymobfarm.config.mobs.BeeAnimal;
import de.markusbordihn.easymobfarm.config.structure.NetherFortress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonConfig {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    private static final String MOB_CATCHING_LUCK_TEXT = "Defines the luck of capturing the mob e.g. luck of 3 means a change of 1 to 3 to capture a mob. Higher numbers requires more luck. 0 = disable luck.";
    private static final String PROCESS_TIME_TEXT = "Defines after how many seconds a loot drop is performed.";

    protected CommonConfig() {
    }

    static {
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("{} Common config ...", (Object)"\ud83e\udea4 Register Bo's Easy Mob Farm");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue informOwnerAboutFullStorage;
        public final ForgeConfigSpec.BooleanValue logFullStorage;
        public final ForgeConfigSpec.IntValue lootPreviewRolls;
        public final ForgeConfigSpec.IntValue animalPlainsFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> animalPlainsFarmMobs;
        public final ForgeConfigSpec.IntValue beeHiveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> beeHiveFarmMobs;
        public final ForgeConfigSpec.IntValue creativeMobFarmProcessTime;
        public final ForgeConfigSpec.IntValue desertFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> desertFarmMobs;
        public final ForgeConfigSpec.IntValue jungleFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> jungleFarmMobs;
        public final ForgeConfigSpec.IntValue monsterPlainsCaveFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> monsterPlainsCaveFarmMobs;
        public final ForgeConfigSpec.IntValue netherFortressFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> netherFortressFarmMobs;
        public final ForgeConfigSpec.IntValue oceanFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> oceanFarmMobs;
        public final ForgeConfigSpec.IntValue swampFarmProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<String>> swampFarmMobs;
        public final ForgeConfigSpec.IntValue catchCageMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> catchCageMobs;
        public final ForgeConfigSpec.IntValue catchCageSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> catchCageSmallMobs;
        public final ForgeConfigSpec.IntValue collarSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> collarSmallMobs;
        public final ForgeConfigSpec.IntValue fishingBowlMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> fishingBowlMobs;
        public final ForgeConfigSpec.IntValue fishingNetSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> fishingNetSmallMobs;
        public final ForgeConfigSpec.IntValue insectNetMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> insectNetMobs;
        public final ForgeConfigSpec.IntValue urnSmallMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> urnSmallMobs;
        public final ForgeConfigSpec.IntValue witchBottleMobCatchingLuck;
        public final ForgeConfigSpec.ConfigValue<List<String>> witchBottleMobs;
        public final ForgeConfigSpec.BooleanValue beeDropHoneycomb;
        public final ForgeConfigSpec.BooleanValue blazeDropBlazeRod;
        public final ForgeConfigSpec.BooleanValue cowDropRawBeef;
        public final ForgeConfigSpec.BooleanValue chickenDropEggs;
        public final ForgeConfigSpec.BooleanValue chickenDropRawChicken;
        public final ForgeConfigSpec.BooleanValue sheepDropRawMutton;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Bo's Easy Mob Farm");
            builder.push("General");
            this.informOwnerAboutFullStorage = builder.comment("Enable/Disable owner messages about full storage to avoid lagging systems.").define("informOwnerAboutFullStorage", true);
            this.logFullStorage = builder.comment("Enable/Disable full storage log messages for the server logs.").define("logFullStorage", true);
            this.lootPreviewRolls = builder.comment("Number of roll's to get the loot preview for a captured mob. Higher numbers require more server load, but giving a more completed overview.").defineInRange("lootPreviewRolls", 2, 1, 5);
            builder.pop();
            builder.push("Animal Plains Farms");
            this.animalPlainsFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("animalPlainsFarmProcessTime", 300, 10, 3600);
            this.animalPlainsFarmMobs = builder.comment("Supported Mobs for the animal plains farm.").define("animalPlainsFarmMobs", new ArrayList<String>(Plains.Passive));
            builder.pop();
            builder.push("Bee Hive Farms");
            this.beeHiveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("beeHiveFarmProcessTime", 300, 10, 3600);
            this.beeHiveFarmMobs = builder.comment("Supported Mobs for the bee hive farm.").define("beeHiveFarmMobs", new ArrayList<String>(BeeAnimal.AllLootable));
            builder.pop();
            builder.push("Creative Mob Farm");
            this.creativeMobFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("creativeMobFarmProcessTime", 60, 10, 3600);
            builder.pop();
            builder.push("Desert Farm");
            this.desertFarmProcessTime = builder.comment("Defines after how many seconds a drop is performed.").defineInRange("desertFarmProcessTime", 300, 10, 3600);
            this.desertFarmMobs = builder.comment("Supported Mobs for the dessert farm.").define("desertFarmMobs", new ArrayList<String>(Desert.All));
            builder.pop();
            builder.push("Jungle Farm");
            this.jungleFarmProcessTime = builder.comment("Defines after how many seconds a drop is performed.").defineInRange("jungleFarmProcessTime", 300, 10, 3600);
            this.jungleFarmMobs = builder.comment("Supported Mobs for the dessert farm.").define("jungleFarmMobs", new ArrayList<String>(Jungle.All));
            builder.pop();
            builder.push("Monster Plains Cave Farm");
            this.monsterPlainsCaveFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("monsterPlainsCaveFarmProcessTime", 300, 10, 3600);
            this.monsterPlainsCaveFarmMobs = builder.comment("Supported Mobs for the monster plains cave farm.").define("monsterPlainsCaveFarmMobs", new ArrayList<String>(PlainsCave.Hostile));
            builder.pop();
            builder.push("Nether Fortress Farm");
            this.netherFortressFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("netherFortressFarmProcessTime", 300, 10, 3600);
            this.netherFortressFarmMobs = builder.comment("Supported Mobs for the nether fortress farm.").define("netherFortressFarmMobs", new ArrayList<String>(NetherFortress.All));
            builder.pop();
            builder.push("Ocean Farm");
            this.oceanFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("oceanFarmProcessTime", 300, 10, 3600);
            this.oceanFarmMobs = builder.comment("Supported Mobs for the ocean farm.").define("oceanFarmMobs", new ArrayList<String>(Ocean.All));
            builder.pop();
            builder.push("Swamp Farm");
            this.swampFarmProcessTime = builder.comment(CommonConfig.PROCESS_TIME_TEXT).defineInRange("swampFarmProcessTime", 300, 10, 3600);
            this.swampFarmMobs = builder.comment("Supported Mobs for the swamp farm.").define("swampFarmMobs", new ArrayList<String>(Swamp.All));
            builder.pop();
            builder.push("Catch Cage (Mob Catching Item)");
            this.catchCageMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("catchCageMobCatchingLuck", 6, 0, 100);
            this.catchCageMobs = builder.comment("Catchable mobs with the catch cage.").define("catchCageMobs", new ArrayList<String>(Arrays.asList("minecraft:panda", "minecraft:polar_bear")));
            builder.pop();
            builder.push("Catch Cage small (Mob Catching Item)");
            this.catchCageSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("catchCageSmallMobCatchingLuck", 3, 0, 100);
            this.catchCageSmallMobs = builder.comment("Catchable mobs with the catch cage small.").define("catchCageSmallMobs", new ArrayList<String>(Arrays.asList("minecraft:chicken", "minecraft:rabbit", "minecraft:parrot")));
            builder.pop();
            builder.push("Collar small (Mob Catching Item)");
            this.collarSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("collarSmallMobCatchingLuck", 3, 0, 100);
            this.collarSmallMobs = builder.comment("Catchable mobs with the collar small.").define("collarSmallMobs", new ArrayList<String>(Arrays.asList("minecraft:chicken", "minecraft:cow", "minecraft:donkey", "minecraft:horse", "minecraft:pig", "minecraft:sheep")));
            builder.pop();
            builder.push("Fishing bowl (Mob Catching Item)");
            this.fishingBowlMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("fishingBowlMobCatchingLuck", 3, 0, 100);
            this.fishingBowlMobs = builder.comment("Catchable mobs with the fishing bowl.").define("fishingBowlMobs", new ArrayList<String>(Arrays.asList("minecraft:cod", "minecraft:salmon", "aquaculture:atlantic_cod", "aquaculture:atlantic_halibut", "aquaculture:atlantic_herring", "aquaculture:blackfish", "aquaculture:pacific_halibut", "aquaculture:pink_salmon", "aquaculture:pollock", "aquaculture:rainbow_trout")));
            builder.pop();
            builder.push("Fishing net small (Mob Catching Item)");
            this.fishingNetSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("fishingNetSmallMobCatchingLuck", 3, 0, 100);
            this.fishingNetSmallMobs = builder.comment("Catchable mobs with the fishing net small.").define("fishingNetSmallMobs", new ArrayList<String>(Arrays.asList("minecraft:cod", "minecraft:salmon", "minecraft:squid", "minecraft:glow_squid", "minecraft:drowned")));
            builder.pop();
            builder.push("Insect net (Mob Catching Item)");
            this.insectNetMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("insectNetMobCatchingLuck", 3, 0, 100);
            this.insectNetMobs = builder.comment("Catchable mobs with the insect net.").define("insectNetMobs", new ArrayList<String>(BeeAnimal.All));
            builder.pop();
            builder.push("Urn small (Mob Catching Item)");
            this.urnSmallMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("urnSmallMobCatchingLuck", 3, 0, 100);
            this.urnSmallMobs = builder.comment("Catchable mobs with the urn small.").define("urnSmallMobs", new ArrayList<String>(Arrays.asList("minecraft:cave_spider", "minecraft:creeper", "minecraft:spider", "minecraft:skeleton", "minecraft:husk", "minecraft:zombie", "minecraft:zombie_villager")));
            builder.pop();
            builder.push("Witch Bottle (Mob Catching Item)");
            this.witchBottleMobCatchingLuck = builder.comment(CommonConfig.MOB_CATCHING_LUCK_TEXT).defineInRange("witchBottleMobCatchingLuck", 10, 0, 100);
            this.witchBottleMobs = builder.comment("Catchable mobs with the witch bottle.").define("witchBottleMobs", new ArrayList<String>(Arrays.asList("minecraft:enderman", "minecraft:slime", "minecraft:witch")));
            builder.pop();
            builder.push("Bee Settings");
            this.beeDropHoneycomb = builder.comment("Enable/Disable honeycomb drops.").define("beeDropHoneycomb", true);
            builder.pop();
            builder.push("Blaze Settings");
            this.blazeDropBlazeRod = builder.comment("Enable/Disable blaze rod drops.").define("blazeDropBlazeRod", true);
            builder.pop();
            builder.push("Cow Settings");
            this.cowDropRawBeef = builder.comment("Enable/Disable cow raw beef drops.").define("cowDropRawBeef", true);
            builder.pop();
            builder.push("Chicken Settings");
            this.chickenDropEggs = builder.comment("Enable/Disable chicken egg drops.").define("chickenDropEggs", true);
            this.chickenDropRawChicken = builder.comment("Enable/Disable raw chicken drops.").define("chickenDropRawChicken", true);
            builder.pop();
            builder.push("Sheep Settings");
            this.sheepDropRawMutton = builder.comment("Enable/Disable sheep raw mutton drops.").define("sheepDropRawMutton", true);
            builder.pop();
        }
    }
}

