/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import com.kwpugh.mob_catcher.ItemMobCatcher;
import com.kwpugh.mob_catcher.ItemMobCatcherHostile;
import com.matyrobbrt.mobcapturingtool.item.CapturingToolItem;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlockItem;
import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapturedMobVirtual {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    private static final String ENTITY_TAG = "entity";
    private static final String ID_TAG = "id";
    private static final String MOD_DATA_TAG = "mob_data";
    private static final String NAME_TAG = "name";
    private static final String SPAWN_DATA_TAG = "SpawnData";

    protected CapturedMobVirtual() {
    }

    public static boolean isSupported(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return true;
        }
        if (Constants.MOB_CATCHER_LOADED && (item instanceof ItemMobCatcher || item instanceof ItemMobCatcherHostile)) {
            CompoundTag compoundTag = itemStack.m_41784_();
            if (compoundTag.m_128441_(MOD_DATA_TAG) && compoundTag.m_128469_(MOD_DATA_TAG).m_128441_(ID_TAG)) {
                return !compoundTag.m_128469_(MOD_DATA_TAG).m_128461_(ID_TAG).isEmpty();
            }
        } else {
            if (Constants.CREATE_LOADED && item instanceof BlazeBurnerBlockItem) {
                BlazeBurnerBlockItem blazeBurnerBlockItem = (BlazeBurnerBlockItem)item;
                return blazeBurnerBlockItem.hasCapturedBlaze();
            }
            if (Constants.MOB_CAPTURING_TOOL_LOADED && item instanceof CapturingToolItem) {
                return CapturingToolItem.getEntityType((ItemStack)itemStack) != null;
            }
            if (item instanceof SpawnEggItem) {
                return true;
            }
            if (Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
                CompoundTag compoundTag = itemStack.m_41784_();
                if (compoundTag.m_128441_(BLOCK_ENTITY_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128441_(SPAWN_DATA_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128441_(ENTITY_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128469_(ENTITY_TAG).m_128441_(ID_TAG)) {
                    return !compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128469_(ENTITY_TAG).m_128461_(ID_TAG).isEmpty();
                }
            } else if (!(item instanceof AirItem)) {
                log.debug("Unsupported mob catching Item {}", (Object)item);
            }
        }
        return false;
    }

    public static boolean hasCapturedMob(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.hasCapturedMob(itemStack);
        }
        if (Constants.MOB_CATCHER_LOADED && (item instanceof ItemMobCatcher || item instanceof ItemMobCatcherHostile)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        if (Constants.CREATE_LOADED && item instanceof BlazeBurnerBlockItem) {
            BlazeBurnerBlockItem blazeBurnerBlockItem = (BlazeBurnerBlockItem)item;
            return blazeBurnerBlockItem.hasCapturedBlaze();
        }
        if (Constants.MOB_CAPTURING_TOOL_LOADED && item instanceof CapturingToolItem) {
            return CapturingToolItem.getEntityType((ItemStack)itemStack) != null;
        }
        if (item instanceof SpawnEggItem) {
            return true;
        }
        if (Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        return false;
    }

    public static String getCapturedMob(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMob(itemStack);
        }
        if (Constants.MOB_CATCHER_LOADED && (item instanceof ItemMobCatcher || item instanceof ItemMobCatcherHostile)) {
            CompoundTag compoundTag = itemStack.m_41784_();
            return compoundTag.m_128461_(NAME_TAG);
        }
        if (Constants.CREATE_LOADED && item instanceof BlazeBurnerBlockItem) {
            return "Blaze";
        }
        if (Constants.MOB_CAPTURING_TOOL_LOADED && item instanceof CapturingToolItem || item instanceof SpawnEggItem || Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
            EntityType<?> entityType = CapturedMobVirtual.getCapturedMobEntityType(itemStack);
            log.info("getCapturedMob: {}", entityType);
            String descriptionId = entityType != null ? entityType.m_20675_() : "";
            return !descriptionId.isBlank() ? new TranslatableComponent(descriptionId).getString() : descriptionId;
        }
        return "";
    }

    public static DyeColor getCapturedMobColor(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobColor(itemStack);
        }
        return null;
    }

    public static EntityType<?> getCapturedMobEntityType(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobEntityType(itemStack);
        }
        if (Constants.MOB_CATCHER_LOADED && (item instanceof ItemMobCatcher || item instanceof ItemMobCatcherHostile) || Constants.CREATE_LOADED && item instanceof BlazeBurnerBlockItem || Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
            String capturedMobType = CapturedMobVirtual.getCapturedMobType(itemStack);
            if (capturedMobType.contains(":")) {
                ResourceLocation resourceLocation = new ResourceLocation(capturedMobType);
                return (EntityType)Registry.f_122826_.m_7745_(resourceLocation);
            }
            log.info("Unable to get capture mob entity type for {}", (Object)capturedMobType);
        } else {
            if (Constants.MOB_CAPTURING_TOOL_LOADED && item instanceof CapturingToolItem) {
                return CapturingToolItem.getEntityType((ItemStack)itemStack);
            }
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                return spawnEggItem.m_43228_(itemStack.m_41784_());
            }
        }
        return null;
    }

    public static String getCapturedMobType(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobType(itemStack);
        }
        if (Constants.MOB_CATCHER_LOADED && (item instanceof ItemMobCatcher || item instanceof ItemMobCatcherHostile)) {
            CompoundTag compoundTag = itemStack.m_41784_();
            return compoundTag.m_128469_(MOD_DATA_TAG).m_128461_(ID_TAG);
        }
        if (Constants.CREATE_LOADED && item instanceof BlazeBurnerBlockItem) {
            return "minecraft:blaze";
        }
        if (Constants.MOB_CAPTURING_TOOL_LOADED && item instanceof CapturingToolItem || item instanceof SpawnEggItem) {
            String[] descriptionIdParts;
            String descriptionId;
            EntityType<?> entityType = CapturedMobVirtual.getCapturedMobEntityType(itemStack);
            String string = descriptionId = entityType != null ? entityType.m_20675_() : "";
            if (descriptionId != null && descriptionId.contains("entity.") && (descriptionIdParts = descriptionId.split("\\.")).length == 3) {
                return descriptionIdParts[1] + ":" + descriptionIdParts[2];
            }
        } else if (Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
            CompoundTag compoundTag = itemStack.m_41784_();
            return compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128469_(ENTITY_TAG).m_128461_(ID_TAG);
        }
        return "";
    }

    public static String getLootTable(ItemStack itemStack) {
        String capturedMobType;
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getLootTable(itemStack);
        }
        if ((Constants.MOB_CATCHER_LOADED && (item instanceof ItemMobCatcher || item instanceof ItemMobCatcherHostile) || Constants.CREATE_LOADED && item instanceof BlazeBurnerBlockItem || Constants.MOB_CAPTURING_TOOL_LOADED && item instanceof CapturingToolItem || item instanceof SpawnEggItem || Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) && (capturedMobType = CapturedMobVirtual.getCapturedMobType(itemStack)) != null && capturedMobType.contains(":")) {
            String[] mobTypeParts = capturedMobType.split("\\:");
            return mobTypeParts[0] + ":entities/" + mobTypeParts[1];
        }
        return "";
    }
}

