/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.block.CapturedMobCompatible;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.text.TranslatableText;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCatcherItem
extends CapturedMob {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final String DEFAULT_DESCRIPTION_ID = "supported_mobs";
    public static final Set<String> ACCEPTED_MOB_TYPES = Collections.emptySet();
    private static int mobCatchingLuck = 3;

    public MobCatcherItem(Item.Properties properties) {
        super(properties);
    }

    public Set<String> getAcceptedMobTypes() {
        return ACCEPTED_MOB_TYPES;
    }

    public boolean canCatchMob(LivingEntity livingEntity) {
        return livingEntity instanceof LivingEntity;
    }

    public boolean canCatchMobType(String mobType) {
        return !mobType.isEmpty();
    }

    public String getCatchingItemDescriptionId() {
        return DEFAULT_DESCRIPTION_ID;
    }

    public int getMobCatchingLuck() {
        return mobCatchingLuck;
    }

    public void appendHoverTextCatchableMobs(List<Component> tooltipList) {
        Set<String> acceptedMobTypes = this.getAcceptedMobTypes();
        if (!acceptedMobTypes.isEmpty()) {
            TranslatableComponent mobTypeOverview = (TranslatableComponent)new TranslatableComponent("").m_130940_(ChatFormatting.DARK_GREEN);
            for (String acceptedMob : acceptedMobTypes) {
                TranslatableComponent acceptedMobName = TranslatableText.getEntityName(acceptedMob);
                if (acceptedMobName.getString().isBlank()) continue;
                mobTypeOverview.m_7220_((Component)acceptedMobName).m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (!mobTypeOverview.getString().isBlank()) {
                TranslatableComponent acceptedMobsOverview = (TranslatableComponent)new TranslatableComponent("text.easy_mob_farm.catchable_mobs").m_130946_(" ").m_130940_(ChatFormatting.GREEN);
                acceptedMobsOverview.m_7220_((Component)mobTypeOverview).m_130946_("...");
                tooltipList.add((Component)acceptedMobsOverview);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        if (block instanceof CapturedMobCompatible) {
            CapturedMobCompatible capturedMobCompatible = (CapturedMobCompatible)block;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (!level.f_46443_ && capturedMobCompatible.canConsumeCapturedMob(level, blockPos, blockState, blockEntity, player, itemStack)) {
                return capturedMobCompatible.consumeCapturedMob(level, blockPos, blockState, blockEntity, itemStack, context);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (MobCatcherItem.hasCapturedMob(itemStack) && !level.f_46443_) {
            if ((blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50037_)) && MobCatcherItem.releaseCapturedMob(itemStack, blockPos, level)) {
                return InteractionResult.CONSUME;
            }
            BlockPos blockPosAbove = blockPos.m_7494_();
            BlockState blockStateBlockAbove = level.m_8055_(blockPosAbove);
            if ((blockStateBlockAbove.m_60795_() || blockStateBlockAbove.m_60713_(Blocks.f_49990_)) && MobCatcherItem.releaseCapturedMob(itemStack, blockPosAbove, level)) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.m_21224_()) {
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.m_183503_();
        if (!MobCatcherItem.hasCapturedMob(itemStack)) {
            String mobType;
            if (MobCatcherItem.willItemBreak(itemStack, 1)) {
                if (level.f_46443_) {
                    player.m_5496_(SoundEvents.f_12018_, 1.0f, 0.0f);
                } else {
                    MobCatcherItem.damageItem(itemStack, 1);
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                return InteractionResult.FAIL;
            }
            ResourceLocation registryName = livingEntity.m_6095_().getRegistryName();
            String string = mobType = registryName != null ? registryName.toString() : null;
            if (!this.canCatchMob(livingEntity) || mobType != null && !this.canCatchMobType(mobType)) {
                log.debug("Unable to catch living entity {}!", (Object)registryName);
                return InteractionResult.FAIL;
            }
            if (level.f_46443_) {
                player.m_5496_(SoundEvents.f_11877_, 1.0f, 0.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.getMobCatchingLuck() != 0) {
                livingEntity.m_5496_(SoundEvents.f_11797_, 1.0f, 0.0f);
                MobCatcherItem.damageItem(itemStack, 1);
                player.m_21008_(hand, itemStack);
                return InteractionResult.FAIL;
            }
            ItemStack capturedMobItem = MobCatcherItem.setCapturedMob(livingEntity, itemStack);
            MobCatcherItem.damageItem(capturedMobItem, 1);
            player.m_21008_(hand, capturedMobItem);
            InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        String entityName = MobCatcherItem.getCapturedMob(itemStack);
        if (entityName.isEmpty()) {
            tooltipList.add((Component)new TranslatableComponent("text.easy_mob_farm.capture"));
            this.appendHoverTextCatchableMobs(tooltipList);
        } else {
            Float entityHealth = MobCatcherItem.getCapturedMobHealth(itemStack);
            tooltipList.add((Component)new TranslatableComponent("text.easy_mob_farm.release", new Object[]{entityName}).m_130940_(ChatFormatting.YELLOW));
            tooltipList.add((Component)new TranslatableComponent("text.easy_mob_farm.catched_mob", new Object[]{entityName}).m_130940_(ChatFormatting.GOLD));
            List<String> possibleLoot = MobCatcherItem.getPossibleLoot(itemStack);
            if (!possibleLoot.isEmpty()) {
                TranslatableComponent lootOverview = (TranslatableComponent)new TranslatableComponent("").m_130940_(ChatFormatting.DARK_GREEN);
                for (String drop : possibleLoot) {
                    TranslatableComponent itemName = TranslatableText.getItemName(drop);
                    if (itemName.getString().isBlank()) continue;
                    lootOverview.m_7220_((Component)itemName).m_130946_(", ");
                }
                if (!lootOverview.getString().isBlank()) {
                    TranslatableComponent possibleLootOverview = (TranslatableComponent)new TranslatableComponent("text.easy_mob_farm.possible_loot").m_130946_(" ").m_130940_(ChatFormatting.GREEN);
                    possibleLootOverview.m_7220_((Component)lootOverview).m_130946_("...");
                    tooltipList.add((Component)possibleLootOverview);
                }
            }
            tooltipList.add((Component)new TranslatableComponent("text.easy_mob_farm.health", new Object[]{entityHealth}));
        }
    }

    public boolean m_5812_(ItemStack itemStack) {
        return MobCatcherItem.hasCapturedMob(itemStack);
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }
}

