/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcatcher;

import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.item.MobCatcherItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CatchCage
extends MobCatcherItem {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int mobCatchingLuck = (Integer)CatchCage.COMMON.catchCageSmallMobCatchingLuck.get();
    private static Set<String> acceptedMobTypes = new HashSet<String>((Collection)CatchCage.COMMON.catchCageMobs.get());

    public CatchCage(Item.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        mobCatchingLuck = (Integer)CatchCage.COMMON.catchCageMobCatchingLuck.get();
        acceptedMobTypes = new HashSet<String>((Collection)CatchCage.COMMON.catchCageMobs.get());
        log.info("The catch cage require {} luck and is able to catch the following mobs: {}", (Object)mobCatchingLuck, acceptedMobTypes);
    }

    @Override
    public Set<String> getAcceptedMobTypes() {
        return acceptedMobTypes;
    }

    @Override
    public boolean canCatchMobType(String mobType) {
        return acceptedMobTypes.contains(mobType);
    }

    @Override
    public int getMobCatchingLuck() {
        return mobCatchingLuck > 0 ? this.random.nextInt(mobCatchingLuck) : 0;
    }
}

