/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcatcher;

import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.item.MobCatcherItem;
import de.markusbordihn.easymobfarm.text.TranslatableText;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class InsectNet
extends MobCatcherItem {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static int mobCatchingLuck = (Integer)InsectNet.COMMON.insectNetMobCatchingLuck.get();
    private static Set<String> acceptedMobTypes = new HashSet<String>((Collection)InsectNet.COMMON.insectNetMobs.get());

    public InsectNet(Item.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        mobCatchingLuck = (Integer)InsectNet.COMMON.insectNetMobCatchingLuck.get();
        acceptedMobTypes = new HashSet<String>((Collection)InsectNet.COMMON.insectNetMobs.get());
        log.info("The insect net require {} luck and is able to catch the following mobs: {}", (Object)mobCatchingLuck, acceptedMobTypes);
    }

    @Override
    public Set<String> getAcceptedMobTypes() {
        return acceptedMobTypes;
    }

    @Override
    public boolean canCatchMobType(String mobType) {
        return acceptedMobTypes.contains(mobType);
    }

    @Override
    public int getMobCatchingLuck() {
        return mobCatchingLuck > 0 ? this.random.nextInt(mobCatchingLuck) : 0;
    }

    @Override
    public void appendHoverTextCatchableMobs(List<Component> tooltipList) {
        if (!acceptedMobTypes.isEmpty()) {
            TranslatableComponent mobTypeOverview = (TranslatableComponent)new TranslatableComponent("").m_130940_(ChatFormatting.DARK_GREEN);
            for (String acceptedMob : acceptedMobTypes) {
                TranslatableComponent acceptedMobName;
                if (!Constants.PRODUCTIVE_BEES_LOADED && acceptedMob.startsWith("productivebees:") || acceptedMobTypes.size() >= 16 && Constants.PRODUCTIVE_BEES_LOADED && acceptedMob.startsWith("productivebees:") || (acceptedMobName = TranslatableText.getEntityName(acceptedMob)).getString().isBlank()) continue;
                mobTypeOverview.m_7220_((Component)acceptedMobName).m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (Constants.PRODUCTIVE_BEES_LOADED && acceptedMobTypes.size() >= 16) {
                mobTypeOverview.m_130946_("Productive Bees").m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (!mobTypeOverview.getString().isBlank()) {
                TranslatableComponent acceptedMobsOverview = (TranslatableComponent)new TranslatableComponent("text.easy_mob_farm.catchable_mobs").m_130946_(" ").m_130940_(ChatFormatting.GREEN);
                acceptedMobsOverview.m_7220_((Component)mobTypeOverview).m_130946_("...");
                tooltipList.add((Component)acceptedMobsOverview);
            }
        }
    }
}

