/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeCreator;
import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.config.mobs.BeeAnimal;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class LootManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Random random = new Random();
    private static boolean beeDropHoneycomb = (Boolean)LootManager.COMMON.beeDropHoneycomb.get();
    private static boolean blazeDropBlazeRod = (Boolean)LootManager.COMMON.blazeDropBlazeRod.get();
    private static boolean cowDropRawBeef = (Boolean)LootManager.COMMON.cowDropRawBeef.get();
    private static boolean chickenDropEggs = (Boolean)LootManager.COMMON.chickenDropEggs.get();
    private static boolean chickenDropRawChicken = (Boolean)LootManager.COMMON.chickenDropRawChicken.get();
    private static boolean sheepDropRawMutton = (Boolean)LootManager.COMMON.sheepDropRawMutton.get();
    private static int lootPreviewRolls = (Integer)LootManager.COMMON.lootPreviewRolls.get();
    private static FakePlayer fakePlayer;
    private static final GameProfile GAME_PROFILE;
    private static Map<ResourceLocation, List<String>> lootTableDropListCache;

    protected LootManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        beeDropHoneycomb = (Boolean)LootManager.COMMON.beeDropHoneycomb.get();
        blazeDropBlazeRod = (Boolean)LootManager.COMMON.blazeDropBlazeRod.get();
        cowDropRawBeef = (Boolean)LootManager.COMMON.cowDropRawBeef.get();
        chickenDropEggs = (Boolean)LootManager.COMMON.chickenDropEggs.get();
        chickenDropRawChicken = (Boolean)LootManager.COMMON.chickenDropRawChicken.get();
        sheepDropRawMutton = (Boolean)LootManager.COMMON.sheepDropRawMutton.get();
        lootPreviewRolls = (Integer)LootManager.COMMON.lootPreviewRolls.get();
        lootTableDropListCache = new ConcurrentHashMap<ResourceLocation, List<String>>();
    }

    public static FakePlayer getPlayer(ServerLevel level) {
        if (fakePlayer == null) {
            fakePlayer = new FakePlayer(level, GAME_PROFILE);
        }
        return fakePlayer;
    }

    public static List<String> getRandomLootDropOverview(ResourceLocation lootTableLocation, Level level, String mobType) {
        List<Object> lootDropList = Lists.newArrayList();
        for (int i = 0; i < lootPreviewRolls; ++i) {
            List<ItemStack> lootDrops = LootManager.getFilteredRandomLootDrop(lootTableLocation, level, mobType);
            lootDropList = LootManager.cacheLootDrops(lootTableLocation, lootDrops);
        }
        log.info("[Loot Manager] Loot for {} with {} roll {} result: {}", (Object)mobType, (Object)lootTableLocation, (Object)lootPreviewRolls, (Object)lootDropList);
        return lootDropList;
    }

    public static List<ItemStack> getRandomLootDrops(ResourceLocation lootTableLocation, Level level) {
        if (lootTableLocation == null || level == null || level.m_142572_() == null) {
            log.error("[Loot Manager] Unable to get loot drops for loot table {} in {}", (Object)lootTableLocation, (Object)level);
            return Lists.newArrayList();
        }
        MinecraftServer server = level.m_142572_();
        if (server != null) {
            ServerLevel serverLevel = (ServerLevel)level;
            FakePlayer player = LootManager.getPlayer(serverLevel);
            LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_());
            builder.m_78963_(0.5f).m_78972_(LootContextParams.f_81455_, (Object)player).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19344_((Player)player));
            LootTable lootTable = server.m_129898_().m_79217_(lootTableLocation);
            List lootDrops = lootTable.m_79129_(builder.m_78975_(LootContextParamSets.f_81415_));
            if (lootDrops.isEmpty()) {
                log.warn("[Loot Manager] Loot drop for {} with loot table {} was empty!", (Object)player, (Object)lootTableLocation);
            }
            return lootDrops;
        }
        return Lists.newArrayList();
    }

    public static List<ItemStack> getFilteredRandomLootDrop(ItemStack itemStack, Level level) {
        ResourceLocation lootTable = null;
        String mobType = "";
        if (itemStack.m_41619_() || !(level instanceof ServerLevel)) {
            return Lists.newArrayList();
        }
        if (itemStack.m_41720_() instanceof CapturedMob) {
            String lootTableLocation = CapturedMob.getLootTable(itemStack);
            if (!lootTableLocation.isEmpty()) {
                lootTable = new ResourceLocation(lootTableLocation);
            }
            mobType = CapturedMob.getCapturedMobType(itemStack);
        } else if (CapturedMobVirtual.isSupported(itemStack)) {
            String lootTableLocation = CapturedMobVirtual.getLootTable(itemStack);
            if (!lootTableLocation.isEmpty()) {
                lootTable = new ResourceLocation(lootTableLocation);
            }
            mobType = CapturedMobVirtual.getCapturedMobType(itemStack);
        } else {
            log.error("[Loot Manager] Unable to process loot drop for {} in {}", (Object)itemStack, (Object)level);
            return Lists.newArrayList();
        }
        return LootManager.getFilteredRandomLootDrop(lootTable, level, mobType);
    }

    public static List<ItemStack> getFilteredRandomLootDrop(ResourceLocation lootTableLocation, Level level, String mobType) {
        List<ItemStack> lootDrops = LootManager.getRandomLootDrops(lootTableLocation, level);
        List<ItemStack> filteredLootDrops = LootManager.getFilteredLootDrop(lootDrops, mobType);
        LootManager.cacheLootDrops(lootTableLocation, filteredLootDrops);
        return filteredLootDrops;
    }

    public static List<ItemStack> getFilteredLootDrop(List<ItemStack> lootDrops, String mobType) {
        ArrayList filteredLootDrops = Lists.newArrayList();
        if (blazeDropBlazeRod && mobType.equals("minecraft:blaze")) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42585_));
        } else if (chickenDropEggs && mobType.equals("minecraft:chicken")) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42521_));
        } else if (beeDropHoneycomb && mobType.equals("minecraft:bee")) {
            if (random.nextInt(3) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42784_));
            }
        } else if (beeDropHoneycomb && Constants.PRODUCTIVE_BEES_LOADED && BeeAnimal.ProductiveBees.contains(mobType)) {
            if (random.nextInt(3) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42784_));
            } else if (random.nextInt(3) == 1) {
                if (mobType.equals("productivebees:ghostly_bee")) {
                    lootDrops.add(new ItemStack((ItemLike)ModItems.HONEYCOMB_GHOSTLY.get()));
                } else if (mobType.equals("productivebees:rancher_bee")) {
                    lootDrops.add(new ItemStack((ItemLike)ModItems.HONEYCOMB_MILKY.get()));
                } else if (mobType.equals("productivebees:creeper_bee")) {
                    lootDrops.add(new ItemStack((ItemLike)ModItems.HONEYCOMB_POWDERY.get()));
                } else {
                    ItemStack honeyComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                    BeeCreator.setTag((String)mobType.replace("_bee", "").replace("_mining", ""), (ItemStack)honeyComb);
                    lootDrops.add(honeyComb);
                }
            }
        }
        for (ItemStack lootDrop : lootDrops) {
            if (lootDrop.m_41619_() || LootManager.filter(chickenDropRawChicken, "minecraft:chicken", Items.f_42581_, mobType, lootDrop) || LootManager.filter(cowDropRawBeef, "minecraft:cow", Items.f_42579_, mobType, lootDrop) || LootManager.filter(sheepDropRawMutton, "minecraft:sheep", Items.f_42658_, mobType, lootDrop)) continue;
            filteredLootDrops.add(lootDrop);
        }
        return filteredLootDrops;
    }

    public static boolean filter(boolean status, String blockedMobType, Item blockedLootDrop, String mobType, ItemStack lootDrop) {
        if (status) {
            return false;
        }
        return mobType.equals(blockedMobType) && lootDrop.m_150930_(blockedLootDrop);
    }

    private static List<String> cacheLootDrops(ResourceLocation lootTableLocation, List<ItemStack> lootDrops) {
        ArrayList lootDropList = Lists.newArrayList();
        if (lootTableLocation == null) {
            return lootDropList;
        }
        List lootDropListCache = lootTableDropListCache.getOrDefault(lootTableLocation, null);
        if (lootDropListCache != null) {
            lootDropList.addAll(lootDropListCache);
        }
        for (ItemStack lootDrop : lootDrops) {
            lootDropList.add(lootDrop.m_41720_().m_5524_());
        }
        return lootTableDropListCache.put(lootTableLocation, lootDropList.stream().distinct().toList());
    }

    static {
        GAME_PROFILE = new GameProfile(UUID.randomUUID(), "[BOs_Easy_Mob_Farm]");
        lootTableDropListCache = new ConcurrentHashMap<ResourceLocation, List<String>>();
    }
}

