/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.menu;

import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import de.markusbordihn.easymobfarm.menu.slots.CapturedMobSlot;
import de.markusbordihn.easymobfarm.menu.slots.LockedResultSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmMenu
extends AbstractContainerMenu {
    public static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    @ObjectHolder(value="easy_mob_farm:mob_farm")
    public static MenuType<MobFarmMenu> TYPE;
    public static final int CAPTURED_MOB_SLOT = 0;
    public static final int RESULT_1_SLOT = 1;
    public static final int RESULT_2_SLOT = 2;
    public static final int RESULT_3_SLOT = 3;
    public static final int RESULT_4_SLOT = 4;
    public static final int RESULT_5_SLOT = 5;
    public static final int PLAYER_SLOT_START = 9;
    public static final int PLAYER_INVENTORY_SLOT_START = 9;
    public static final int PLAYER_SLOT_STOP = 44;
    public static final int CAPTURED_MOB_SLOT_LEFT = 44;
    public static final int CAPTURED_MOB_SLOT_TOP = 22;
    public static final int RESULT_SLOTS_LEFT = 44;
    public static final int RESULT_SLOTS_TOP = 59;
    private static int containerSize;
    private static int slotSize;
    private static int slotSpacing;
    private final Container container;
    private final ContainerData data;
    private ItemStack mobFarmCapturedMob = ItemStack.f_41583_;
    private String mobFarmName = "- unknown -";
    private String mobFarmTotalTimeText = "";
    private String mobFarmType = "";
    private int mobFarmProgress;
    private int mobFarmProgressImage;
    private int mobFarmRemainingTime;
    private int mobFarmStatus;
    private int mobFarmTotalTime;
    protected final Level level;

    public MobFarmMenu(int windowIdIn, Inventory inventory) {
        this(windowIdIn, inventory, (Container)new SimpleContainer(containerSize), (ContainerData)new SimpleContainerData(6), TYPE);
    }

    public MobFarmMenu(int windowId, Inventory playerInventory, Container container, ContainerData containerData) {
        this(windowId, playerInventory, container, containerData, TYPE);
    }

    public MobFarmMenu(int windowId, Inventory playerInventory, Container container, ContainerData containerData, MenuType<?> menuType) {
        super(menuType, windowId);
        MobFarmMenu.m_38869_((Container)container, (int)containerSize);
        MobFarmMenu.m_38886_((ContainerData)containerData, (int)6);
        this.container = container;
        this.data = containerData;
        this.level = playerInventory.f_35978_.f_19853_;
        this.m_38897_(new CapturedMobSlot(container, 0, 44, 22, this));
        this.m_38897_(new LockedResultSlot(container, 1, 44, 59));
        this.m_38897_(new LockedResultSlot(container, 2, 62, 59));
        this.m_38897_(new LockedResultSlot(container, 3, 80, 59));
        this.m_38897_(new LockedResultSlot(container, 4, 98, 59));
        this.m_38897_(new LockedResultSlot(container, 5, 116, 59));
        int playerInventoryStartPositionY = 99;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.m_38897_(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, slotSpacing + inventoryColumn * slotSize, playerInventoryStartPositionY + inventoryRow * slotSize));
            }
        }
        int hotbarStartPositionY = 157;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.m_38897_(new Slot((Container)playerInventory, playerInventorySlot, slotSpacing + playerInventorySlot * slotSize, hotbarStartPositionY));
        }
        this.m_38884_(containerData);
    }

    public void updateMobFarmDataCache() {
        ItemStack currentItemStack = this.container.m_8020_(0);
        if (!this.mobFarmCapturedMob.m_150930_(currentItemStack.m_41720_())) {
            if (currentItemStack.m_41619_()) {
                this.mobFarmName = "- unknown -";
                this.mobFarmType = "";
            } else if (currentItemStack.m_41720_() instanceof CapturedMob) {
                this.mobFarmName = CapturedMob.getCapturedMob(currentItemStack);
                this.mobFarmType = CapturedMob.getCapturedMobType(currentItemStack);
            } else if (CapturedMobVirtual.isSupported(currentItemStack)) {
                this.mobFarmName = CapturedMobVirtual.getCapturedMob(currentItemStack);
                this.mobFarmType = CapturedMobVirtual.getCapturedMobType(currentItemStack);
            }
            this.mobFarmCapturedMob = currentItemStack;
        }
        this.mobFarmProgress = this.data.m_6413_(2);
        this.mobFarmTotalTime = this.data.m_6413_(3);
        this.mobFarmTotalTimeText = this.mobFarmTotalTime / 20 + "s";
        this.mobFarmStatus = this.data.m_6413_(4);
        if (!this.mobFarmCapturedMob.m_41619_()) {
            int adaptiveTotalPixelHeight = this.mobFarmTotalTime > 200 ? 15 : 16;
            this.mobFarmProgressImage = this.mobFarmTotalTime != 0 && this.mobFarmProgress != 0 ? this.mobFarmProgress * adaptiveTotalPixelHeight / this.mobFarmTotalTime : 0;
            this.mobFarmRemainingTime = (this.mobFarmTotalTime - this.mobFarmProgress) / 20;
        }
    }

    public int getMobFarmProgress() {
        return this.mobFarmProgress;
    }

    public int getMobFarmTotalTime() {
        return this.mobFarmTotalTime;
    }

    public String getMobFarmTotalTimeText() {
        return this.mobFarmTotalTimeText;
    }

    public int getMobFarmStatus() {
        return this.mobFarmStatus;
    }

    public int getMobFarmProgressImage() {
        return this.mobFarmProgressImage;
    }

    public int getMobFarmRemainingTime() {
        return this.mobFarmRemainingTime;
    }

    public String getMobFarmName() {
        return this.mobFarmName;
    }

    public String getMobFarmType() {
        return this.mobFarmType;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public boolean mayPlaceCapturedMob(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof CapturedMob) {
            return CapturedMob.hasCapturedMob(itemStack);
        }
        if (CapturedMobVirtual.isSupported(itemStack)) {
            return CapturedMobVirtual.hasCapturedMob(itemStack);
        }
        return false;
    }

    public boolean mayPlaceCapturedMobType(String mobType) {
        return !mobType.isBlank();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41720_() instanceof CapturedMob ? (slotIndex == 0 ? !this.m_38903_(itemStack, 6, 42, false) : slotIndex >= 6 && !this.m_38903_(itemStack, 0, 1, false)) : (slotIndex == 1 || slotIndex == 2 || slotIndex == 3 || slotIndex == 4 || slotIndex == 5) && this.m_38903_(itemStack, 6, 42, false)) {
            return ItemStack.f_41583_;
        }
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, itemStack);
        return ItemStack.f_41583_;
    }

    static {
        containerSize = 6;
        slotSize = 18;
        slotSpacing = 8;
    }
}

