/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.text;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class TranslatableText {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static Map<String, TranslatableComponent> entityNameCache = new ConcurrentHashMap<String, TranslatableComponent>();
    private static Map<String, TranslatableComponent> itemNameCache = new ConcurrentHashMap<String, TranslatableComponent>();

    protected TranslatableText() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        entityNameCache = new ConcurrentHashMap<String, TranslatableComponent>();
        itemNameCache = new ConcurrentHashMap<String, TranslatableComponent>();
    }

    public static TranslatableComponent getEntityName(String entityName) {
        if (!((String)entityName).contains("entity.") && ((String)entityName).contains(":")) {
            entityName = "entity." + ((String)entityName).replace(':', '.');
        }
        return entityNameCache.computeIfAbsent((String)entityName, key -> {
            TranslatableComponent translatableComponent = new TranslatableComponent(key);
            if (!translatableComponent.getString().equals(key)) {
                return translatableComponent;
            }
            return new TranslatableComponent("");
        });
    }

    public static TranslatableComponent getItemName(String itemName) {
        return itemNameCache.computeIfAbsent(itemName, key -> {
            TranslatableComponent translatableComponent = new TranslatableComponent(itemName);
            if (!translatableComponent.getString().equals(itemName)) {
                return translatableComponent;
            }
            return new TranslatableComponent("");
        });
    }
}

