/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.minecraft.materialelements.block.rod;

import de.markusbordihn.minecraft.materialelements.block.rod.RodComplexBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Rod
extends RodComplexBlock {
    protected static final Logger log = LogManager.getLogger((String)"Material Elements");
    protected static final VoxelShape FLOOR_CEILING_AABB = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape WALL_NORTH_SOUTH_AABB = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape WALL_EAST_WEST_AABB = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);

    public Rod(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        AttachFace attachFace = (AttachFace)blockState.m_61143_(RodComplexBlock.ATTACH_FACE);
        if (attachFace == AttachFace.FLOOR || attachFace == AttachFace.CEILING) {
            return FLOOR_CEILING_AABB;
        }
        switch ((Direction)blockState.m_61143_((Property)RodComplexBlock.FACING)) {
            case NORTH: 
            case SOUTH: {
                return WALL_NORTH_SOUTH_AABB;
            }
            case EAST: 
            case WEST: {
                return WALL_EAST_WEST_AABB;
            }
        }
        return FLOOR_CEILING_AABB;
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean status) {
        AttachFace attachFace = (AttachFace)blockState.m_61143_(RodComplexBlock.ATTACH_FACE);
        Direction facingDirection = (Direction)blockState.m_61143_((Property)RodComplexBlock.FACING);
        if (attachFace == AttachFace.WALL) {
            if (facingDirection == Direction.NORTH || facingDirection == Direction.SOUTH) {
                BlockState blockStateNorth = level.m_8055_(blockPos.m_122012_());
                BlockState blockStateSouth = level.m_8055_(blockPos.m_122019_());
                if (blockStateNorth.m_60734_() instanceof RodComplexBlock) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(blockPos.m_122012_(), (BlockState)blockStateNorth.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                }
                if (blockStateSouth.m_60734_() instanceof RodComplexBlock) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(blockPos.m_122019_(), (BlockState)blockStateSouth.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                }
            }
            if (facingDirection == Direction.EAST || facingDirection == Direction.WEST) {
                BlockState blockStateEast = level.m_8055_(blockPos.m_122029_());
                BlockState blockStateWest = level.m_8055_(blockPos.m_122024_());
                if (blockStateEast.m_60734_() instanceof RodComplexBlock) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(blockPos.m_122029_(), (BlockState)blockStateEast.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                }
                if (blockStateWest.m_60734_() instanceof RodComplexBlock) {
                    level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(blockPos.m_122024_(), (BlockState)blockStateWest.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
        if (attachFace == AttachFace.FLOOR || attachFace == AttachFace.CEILING) {
            BlockState blockStateUp = level.m_8055_(blockPos.m_7494_());
            BlockState blockStateDown = level.m_8055_(blockPos.m_7495_());
            if (blockStateUp.m_60734_() instanceof RodComplexBlock) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                level.m_46597_(blockPos.m_7494_(), (BlockState)blockStateUp.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
            }
            if (blockStateDown.m_60734_() instanceof RodComplexBlock) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
                level.m_46597_(blockPos.m_7495_(), (BlockState)blockStateDown.m_61124_((Property)RodComplexBlock.CONNECTED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }
}

