/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.ModBlocks;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.block.entity.farm.MonsterPlainsCaveFarmEntity;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class MonsterPlainsCaveFarm
extends MobFarmBlock {
    public static final String NAME = "monster_plains_cave_farm";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static Set<String> acceptedMobTypes = new HashSet<String>();

    public MonsterPlainsCaveFarm(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        acceptedMobTypes = new HashSet<String>((Collection)MonsterPlainsCaveFarm.COMMON.monsterPlainsCaveFarmMobs.get());
        log.info("The {} will accept the following mobs: {}", (Object)NAME, acceptedMobTypes);
    }

    public static boolean isAcceptedCapturedMobType(String mobType) {
        return acceptedMobTypes.contains(mobType);
    }

    @Override
    public Set<String> getAcceptedMobTypes() {
        return acceptedMobTypes;
    }

    @Override
    public boolean isAcceptedMobType(String mobType) {
        return acceptedMobTypes.contains(mobType);
    }

    @Override
    public String getFarmDescriptionId() {
        return "supported_monster";
    }

    @Override
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new MonsterPlainsCaveFarmEntity((BlockEntityType)ModBlocks.MONSTER_PLAINS_CAVE_FARM_ENTITY.get(), blockPos, blockState);
    }

    @Override
    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof MonsterPlainsCaveFarmEntity) {
            MonsterPlainsCaveFarmEntity monsterPlainsCaveFarmEntity = (MonsterPlainsCaveFarmEntity)blockEntity;
            player.m_5893_((MenuProvider)monsterPlainsCaveFarmEntity);
        }
    }

    @Override
    public InteractionResult consumeCapturedMob(Level level, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity, ItemStack itemStack, UseOnContext context) {
        MonsterPlainsCaveFarmEntity monsterPlainsCaveMobFarmEntity = (MonsterPlainsCaveFarmEntity)blockEntity;
        monsterPlainsCaveMobFarmEntity.updateLevel(level);
        if (!monsterPlainsCaveMobFarmEntity.hasItem(0)) {
            monsterPlainsCaveMobFarmEntity.m_6836_(0, itemStack);
            context.m_43723_().m_21008_(context.m_43724_(), ItemStack.f_41583_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : MonsterPlainsCaveFarm.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.MONSTER_PLAINS_CAVE_FARM_ENTITY.get()), MobFarmBlockEntity::serverTick);
    }
}

