/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.client.screen.Snapshots;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final ResourceLocation TEXTURE = new ResourceLocation("easy_mob_farm", "textures/container/mob_farm_gui.png");
    public static final int SNAP_WITH = 34;
    public static final int SNAP_HEIGHT = 53;
    private int ticker = 0;
    private int totalTimeLabelX;
    private int totalTimeLabelY;
    private float totalTimeLabelScale = 0.75f;
    private Component warningFullText;
    private MobFarmMenu mobFarmMenu;
    public ResourceLocation backgroundTexture = TEXTURE;

    public MobFarmScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.mobFarmMenu = (MobFarmMenu)((Object)menu);
    }

    protected void renderSnapshot(PoseStack poseStack, ResourceLocation mobFarmTypeSnapshot) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)mobFarmTypeSnapshot);
        MobFarmScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 6), (int)(this.f_97736_ + 22), (float)0.0f, (float)0.0f, (int)34, (int)53, (int)34, (int)53);
    }

    public void m_7856_() {
        super.m_7856_();
        this.ticker = 0;
        this.f_97727_ = 180;
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97731_ = this.f_97727_ - 93;
        this.totalTimeLabelX = Math.round(45.0f / this.totalTimeLabelScale);
        this.totalTimeLabelY = Math.round(78.0f / this.totalTimeLabelScale);
        this.warningFullText = Component.m_237115_((String)"text.easy_mob_farm.warning_full");
    }

    public void m_6305_(PoseStack poseStack, int x, int y, float partialTicks) {
        ResourceLocation mobFarmTypeSnapshot;
        if ((this.ticker++ & 0x27) == 0) {
            this.mobFarmMenu.updateMobFarmDataCache();
            if (this.ticker >= 40) {
                this.ticker = 0;
            }
        }
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, x, y, partialTicks);
        String mobFarmType = this.mobFarmMenu.getMobFarmType();
        if (!mobFarmType.isBlank() && this.mobFarmMenu.getMobFarmStatus() != 2 && (mobFarmTypeSnapshot = Snapshots.getSnapshot(mobFarmType)) != null) {
            this.renderSnapshot(poseStack, mobFarmTypeSnapshot);
        }
        this.m_7025_(poseStack, x, y);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        super.m_7027_(poseStack, x, y);
        int mobFarmStatus = this.mobFarmMenu.getMobFarmStatus();
        poseStack.m_85836_();
        this.f_96547_.m_92883_(poseStack, "Drop Time:", 65.0f, 45.0f, Constants.FONT_COLOR_BLACK);
        this.f_96547_.m_92883_(poseStack, this.mobFarmMenu.getMobFarmTotalTimeText(), 118.0f, 45.0f, Constants.FONT_COLOR_GRAY);
        poseStack.m_85849_();
        if (mobFarmStatus != 2) {
            poseStack.m_85836_();
            this.f_96547_.m_92883_(poseStack, "Mob:", 65.0f, 25.0f, Constants.FONT_COLOR_BLACK);
            this.f_96547_.m_92883_(poseStack, this.mobFarmMenu.getMobFarmName(), 86.0f, 25.0f, Constants.FONT_COLOR_DARK_GREEN);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.65f, 0.65f, 0.65f);
            this.f_96547_.m_92883_(poseStack, this.mobFarmMenu.getMobFarmType(), 100.0f, 52.0f, Constants.FONT_COLOR_GRAY);
            poseStack.m_85849_();
        }
        switch (mobFarmStatus) {
            case 0: 
            case 3: {
                poseStack.m_85836_();
                poseStack.m_85841_(this.totalTimeLabelScale, this.totalTimeLabelScale, this.totalTimeLabelScale);
                this.f_96547_.m_92889_(poseStack, (Component)Component.m_237110_((String)"text.easy_mob_farm.next_drop_secs", (Object[])new Object[]{this.mobFarmMenu.getMobFarmRemainingTime()}), (float)this.totalTimeLabelX, (float)this.totalTimeLabelY, Constants.FONT_COLOR_GRAY);
                poseStack.m_85849_();
                break;
            }
            case 1: {
                poseStack.m_85836_();
                poseStack.m_85841_(this.totalTimeLabelScale, this.totalTimeLabelScale, this.totalTimeLabelScale);
                this.f_96547_.m_92889_(poseStack, this.warningFullText, (float)this.totalTimeLabelX, (float)this.totalTimeLabelY, Constants.FONT_COLOR_WARNING);
                poseStack.m_85849_();
                break;
            }
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.backgroundTexture);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        switch (this.mobFarmMenu.getMobFarmStatus()) {
            case 0: 
            case 3: {
                int mobFarmProgress = this.mobFarmMenu.getMobFarmProgressImage();
                int mobFarmProgressLeftPos = this.f_97735_ + 43;
                int mobFarmProgressTopPos = this.f_97736_ + 41;
                this.m_93228_(poseStack, mobFarmProgressLeftPos, mobFarmProgressTopPos, 194, 14, 18, mobFarmProgress);
                break;
            }
            case 1: {
                int mobFarmFullLeftPos = this.f_97735_ + 43;
                int mobFarmFullTopPos = this.f_97736_ + 41;
                this.m_93228_(poseStack, mobFarmFullLeftPos, mobFarmFullTopPos, 176, 14, 18, 15);
                break;
            }
            case 2: {
                int mobFarmHintLeftPos = this.f_97735_ + 65;
                int mobFarmHintTopPos = this.f_97736_ + 21;
                this.m_93228_(poseStack, mobFarmHintLeftPos, mobFarmHintTopPos, 220, 14, 20, 15);
                break;
            }
        }
    }
}

