/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.client.rendering;

import java.util.Collections;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_897;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.AnimationUtils;
import tech.thatgravyboat.playdate.client.rendering.BalloonModel;
import tech.thatgravyboat.playdate.common.entity.BalloonEntity;
import tech.thatgravyboat.playdate.common.utils.Color;

public class BalloonRenderer
extends class_897<BalloonEntity>
implements IGeoRenderer<BalloonEntity> {
    private final AnimatedGeoModel<BalloonEntity> modelProvider = new BalloonModel();
    public class_4597 rtb;
    public class_2960 whTexture;

    public BalloonRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(BalloonEntity entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 bufferIn, int packedLightIn) {
        stack.method_22903();
        boolean shouldSit = entity.method_5765() && entity.method_5854() != null;
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entity, 0.0f, 0.0f, partialTicks, false, Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation((Object)entity));
        this.modelProvider.setLivingAnimations((IAnimatable)entity, this.getUniqueID(entity), predicate);
        stack.method_22904(0.0, (double)0.01f, 0.0);
        stack.method_22907(class_1160.field_20704.method_23214((float)(entity.method_5667().getLeastSignificantBits() % 360L)));
        class_310.method_1551().method_1531().method_22813(this.getTexture(entity));
        class_1921 renderType = this.getRenderType((Object)entity, partialTicks, stack, bufferIn, null, packedLightIn, this.getTexture(entity));
        boolean invis = entity.method_5756((class_1657)class_310.method_1551().field_1724);
        int color = !entity.getTexture().colored ? -1 : (entity.isRainbow() ? Color.RAINBOW.getRGBA() : entity.getColor());
        this.render(model, (Object)entity, partialTicks, renderType, stack, bufferIn, null, packedLightIn, class_4608.method_23624((float)class_4608.method_23210((float)0.0f), (boolean)false), (float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f, invis ? 0.0f : 1.0f);
        stack.method_22909();
        super.method_3936((class_1297)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        this.renderLeash(entity, partialTicks, stack, bufferIn);
    }

    public Integer getUniqueID(BalloonEntity animatable) {
        return animatable.method_5667().hashCode();
    }

    public void renderEarly(BalloonEntity animatable, class_4587 stackIn, float ticks, class_4597 renderTypeBuffer, class_4588 vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.rtb = renderTypeBuffer;
        this.whTexture = this.getTextureLocation(animatable);
        super.renderEarly((Object)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    public class_2960 getTexture(BalloonEntity entity) {
        return this.getTextureLocation(entity);
    }

    public void setCurrentRTB(class_4597 rtb) {
        this.rtb = rtb;
    }

    public class_4597 getCurrentRTB() {
        return this.rtb;
    }

    public GeoModelProvider<BalloonEntity> getGeoModelProvider() {
        return this.modelProvider;
    }

    protected boolean hasLabel(BalloonEntity entity) {
        return false;
    }

    public class_2960 getTextureLocation(BalloonEntity instance) {
        return this.modelProvider.getTextureLocation((Object)instance);
    }

    private void renderLeash(BalloonEntity entity, float tickDelta, class_4587 matrices, class_4597 provider) {
        int u;
        class_1297 holder = entity.getHolder();
        matrices.method_22903();
        class_243 vec3d = holder == null ? new class_243(entity.method_23317() + 0.001, entity.method_23318() - (double)entity.getRopeLength(), entity.method_23321() + 0.001) : holder.method_30951(tickDelta);
        double g = class_3532.method_16436((double)tickDelta, (double)entity.field_6014, (double)entity.method_23317());
        double h = class_3532.method_16436((double)tickDelta, (double)entity.field_6036, (double)entity.method_23318());
        double i = class_3532.method_16436((double)tickDelta, (double)entity.field_5969, (double)entity.method_23321());
        float j = (float)(vec3d.field_1352 - g);
        float k = (float)(vec3d.field_1351 - h);
        float l = (float)(vec3d.field_1350 - i);
        class_4588 vertexConsumer = provider.getBuffer(class_1921.method_23587());
        class_1159 matrix4f = matrices.method_23760().method_23761();
        float n = class_3532.method_22858((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        class_2338 blockPos = new class_2338(entity.method_5836(tickDelta));
        class_2338 blockPos2 = holder == null ? blockPos : new class_2338(holder.method_5836(tickDelta));
        int q = this.method_24087(entity, blockPos);
        int r = holder != null && holder.method_5809() ? 15 : entity.field_6002.method_8314(class_1944.field_9282, blockPos2);
        int s = entity.field_6002.method_8314(class_1944.field_9284, blockPos);
        int t = entity.field_6002.method_8314(class_1944.field_9284, blockPos2);
        for (u = 0; u <= 24; ++u) {
            BalloonRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            BalloonRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        matrices.method_22909();
    }

    private static void renderLeashPiece(class_4588 vertexConsumer, class_1159 positionMatrix, float f, float g, float h, int leashedEntityBlockLight, int holdingEntityBlockLight, int leashedEntitySkyLight, int holdingEntitySkyLight, float i, float j, float k, float l, int pieceIndex, boolean isLeashKnot) {
        float m = (float)pieceIndex / 24.0f;
        int n = (int)class_3532.method_16439((float)m, (float)leashedEntityBlockLight, (float)holdingEntityBlockLight);
        int o = (int)class_3532.method_16439((float)m, (float)leashedEntitySkyLight, (float)holdingEntitySkyLight);
        int p = class_765.method_23687((int)n, (int)o);
        float q = pieceIndex % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.5f * q;
        float s = 0.4f * q;
        float t = 0.3f * q;
        float u = f * m;
        float v = g > 0.0f ? g * m * m : g - g * (1.0f - m) * (1.0f - m);
        float w = h * m;
        vertexConsumer.method_22918(positionMatrix, u - k, v + j, w + l).method_22915(r, s, t, 1.0f).method_22916(p).method_1344();
        vertexConsumer.method_22918(positionMatrix, u + k, v + i - j, w - l).method_22915(r, s, t, 1.0f).method_22916(p).method_1344();
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof BalloonEntity) {
                return (IAnimatableModel)AnimationUtils.getGeoModelForEntity((class_1297)((BalloonEntity)((Object)object)));
            }
            return null;
        });
    }
}

