/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.entity;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1530;
import net.minecraft.class_1532;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.playdate.common.constants.BalloonType;

public class BalloonEntity
extends class_1297
implements IAnimatable {
    private static final class_2940<Byte> TEXTURE = class_2945.method_12791(BalloonEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> RAINBOW = class_2945.method_12791(BalloonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> COLOR = class_2945.method_12791(BalloonEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> HOLDER_ID = class_2945.method_12791(BalloonEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> ROPE_LENGTH = class_2945.method_12791(BalloonEntity.class, (class_2941)class_2943.field_13320);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private class_1297 holder;
    private class_2487 rope;

    public BalloonEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public void method_5773() {
        super.method_5773();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        if (this.rope != null) {
            this.readRopeData();
        }
        if (this.rope == null) {
            double distance;
            if (!(this.holder == null || this.holder.method_5805() && this.method_5805())) {
                this.detachRope();
            }
            if (this.holder != null && (distance = this.distanceToHolder()) < (double)(this.getRopeLength() + 2.0f)) {
                class_243 multiply = this.holder.method_33571().method_1020(this.method_19538()).method_1029().method_1021(distance * 0.1);
                this.method_18800(multiply.field_1352, 0.0, multiply.field_1350);
            }
            if (this.holder == null || this.distanceToHolder() < (double)this.getRopeLength() || this.distanceToHolder() > (double)(this.getRopeLength() + 2.0f)) {
                class_243 velocity = this.method_18798();
                this.method_18800(velocity.field_1352, class_3532.method_15350((double)(velocity.field_1351 * (double)1.08f), (double)0.01f, (double)0.15f), velocity.field_1350);
            }
            double x = (double)(class_3532.method_15362((float)(this.field_6012 + this.method_5628() * 5 % 189503)) / 160.0f) * Math.PI;
            double z = (double)(class_3532.method_15374((float)(this.field_6012 + this.method_5628() * 5 % 189503)) / 160.0f) * Math.PI;
            this.method_5762(x, 0.0, z);
            this.method_5784(class_1313.field_6308, this.method_18798());
            if (this.holder != null && this.distanceToHolder() > (double)(this.getRopeLength() + 2.0f)) {
                this.detachRope();
            }
            if (this.field_6002.method_31606(this.method_24515())) {
                this.pop();
            }
        }
    }

    private double distanceToHolder() {
        if (this.holder == null) {
            return 0.0;
        }
        return Math.sqrt(this.method_5707(this.holder.method_33571()));
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.method_5805()) {
            if (this.getHolder() == null) {
                this.attachRope((class_1297)player);
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (this.getHolder() == player) {
                this.detachRope();
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
        }
        return super.method_5688(player, hand);
    }

    private void pop() {
        this.method_31472();
        for (int i = 0; i < 10; ++i) {
            this.field_6002.method_8406((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_5527()) {
            return false;
        }
        this.pop();
        return true;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_5693() {
        this.method_5841().method_12784(RAINBOW, (Object)false);
        this.method_5841().method_12784(COLOR, (Object)-1);
        this.method_5841().method_12784(TEXTURE, (Object)-1);
        this.method_5841().method_12784(HOLDER_ID, (Object)0);
        this.method_5841().method_12784(ROPE_LENGTH, (Object)Float.valueOf(2.0f));
    }

    public void method_5674(class_2940<?> data) {
        class_1297 holder;
        super.method_5674(data);
        if (HOLDER_ID.equals(data) && this.field_6002.field_9236 && (holder = this.field_6002.method_8469(((Integer)this.method_5841().method_12789(HOLDER_ID)).intValue())) != null) {
            this.holder = holder;
        }
    }

    public float getRopeLength() {
        return ((Float)this.method_5841().method_12789(ROPE_LENGTH)).floatValue();
    }

    public void setRopeLength(float value) {
        this.method_5841().method_12778(ROPE_LENGTH, (Object)Float.valueOf(value));
    }

    public boolean isRainbow() {
        return (Boolean)this.method_5841().method_12789(RAINBOW);
    }

    public void setRainbow(boolean value) {
        this.method_5841().method_12778(RAINBOW, (Object)value);
    }

    public int getColor() {
        return (Integer)this.method_5841().method_12789(COLOR);
    }

    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, (Object)value);
    }

    public BalloonType getTexture() {
        return BalloonType.getTypeFromId((Byte)this.method_5841().method_12789(TEXTURE));
    }

    public void setTexture(BalloonType value) {
        this.method_5841().method_12778(TEXTURE, (Object)((byte)value.ordinal()));
    }

    protected void method_5749(class_2487 nbt) {
        this.setRainbow(nbt.method_10577("rainbow"));
        this.setColor(nbt.method_10550("color"));
        this.setTexture(BalloonType.getTypeFromId(nbt.method_10558("texture")));
        this.rope = nbt.method_10562("rope");
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10556("rainbow", this.isRainbow());
        nbt.method_10569("color", this.getColor());
        nbt.method_10582("texture", this.getTexture().id);
        if (this.holder != null) {
            class_2487 ropeData = new class_2487();
            if (this.holder instanceof class_1309) {
                ropeData.method_25927("uuid", this.holder.method_5667());
            } else {
                class_1297 class_12972 = this.holder;
                if (class_12972 instanceof class_1530) {
                    class_1530 decor = (class_1530)class_12972;
                    ropeData.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)decor.method_6896()));
                }
            }
            nbt.method_10566("rope", (class_2520)ropeData);
        } else if (this.rope != null) {
            nbt.method_10566("rope", (class_2520)this.rope.method_10553());
        }
    }

    private void readRopeData() {
        class_1937 class_19372;
        if (this.rope != null && (class_19372 = this.field_6002) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (this.rope.method_25928("uuid")) {
                class_1297 entity = server.method_14190(this.rope.method_25926("uuid"));
                if (entity != null) {
                    this.attachRope(entity);
                    return;
                }
            } else if (this.rope.method_10573("pos", 10)) {
                class_2338 blockPos = class_2512.method_10691((class_2487)this.rope.method_10562("pos"));
                class_1532 orCreate = class_1532.method_6932((class_1937)this.field_6002, (class_2338)blockPos);
                this.attachRope((class_1297)orCreate);
                return;
            }
            if (this.field_6012 > 100) {
                this.rope = null;
            }
        }
    }

    public void attachRope(class_1297 entity) {
        this.holder = entity;
        this.rope = null;
        if (!this.field_6002.field_9236) {
            this.method_5841().method_12778(HOLDER_ID, (Object)entity.method_5628());
        }
    }

    private void detachRope() {
        if (this.holder != null && this.field_6012 > 100) {
            this.holder = null;
            this.rope = null;
            this.method_5841().method_12778(HOLDER_ID, (Object)0);
        }
    }

    @Nullable
    public class_1297 getHolder() {
        Integer holdingId = (Integer)this.method_5841().method_12789(HOLDER_ID);
        if (this.holder == null && holdingId != 0 && this.field_6002.field_9236) {
            this.holder = this.field_6002.method_8469(holdingId.intValue());
        }
        return this.holder;
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

