/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import tech.thatgravyboat.playdate.client.forge.PlaydateClientImpl;
import tech.thatgravyboat.playdate.client.screens.Basic5SlotScreen;
import tech.thatgravyboat.playdate.client.screens.ToyBenchScreen;
import tech.thatgravyboat.playdate.common.registry.ModBlocks;
import tech.thatgravyboat.playdate.common.registry.ModEntities;
import tech.thatgravyboat.playdate.common.registry.ModMenus;

public class PlaydateClient {
    public static void init() {
        PlaydateClient.initScreens();
        PlaydateClient.initRenderTypes();
    }

    public static void initScreens() {
        PlaydateClient.registerScreen(ModMenus.TOY_BENCH.get(), ToyBenchScreen::new);
        PlaydateClient.registerScreen(ModMenus.BASIC_5.get(), Basic5SlotScreen::new);
    }

    public static void onEntityRender(Renderers renderers) {
        renderers.registerEntity(ModEntities.SEAT.get(), NoopRenderer::new);
    }

    public static void initRenderTypes() {
        PlaydateClient.registerRenderType(RenderType.m_110463_(), ModBlocks.MUSIC_BOX.get(), ModBlocks.DINO.get(), ModBlocks.MUSIC_BOX.get());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerRenderType(RenderType type, Block ... blocks) {
        void var1_1;
        PlaydateClientImpl.registerRenderType(type, (Block[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <M extends AbstractContainerMenu, U extends Screen> void registerScreen(MenuType<? extends M> menuType, ScreenConstructor<M, U> screenConstructor) {
        void var1_1;
        PlaydateClientImpl.registerScreen(menuType, var1_1);
    }

    @FunctionalInterface
    public static interface ScreenConstructor<T extends AbstractContainerMenu, U extends Screen> {
        public U create(T var1, Inventory var2, Component var3);
    }

    public static interface Renderers {
        public <T extends Entity> void registerEntity(EntityType<? extends T> var1, EntityRendererProvider<T> var2);
    }
}

