/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.blocks;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.playdate.common.blocks.DirectionalToyBlock;
import tech.thatgravyboat.playdate.common.blocks.shapes.ShapeGetter;
import tech.thatgravyboat.playdate.common.registry.ModSoundEvents;
import tech.thatgravyboat.playdate.mixins.client.LevelRendererAccessor;

public class MusicBoxBlock
extends DirectionalToyBlock {
    public MusicBoxBlock(ShapeGetter shape, BlockBehaviour.Properties properties) {
        super(shape, properties);
    }

    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        level.m_7696_(pos, (Block)this, 1, 0);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            level.m_46796_(1010, pos, 0);
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    public boolean m_8133_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, int i, int j) {
        if (i == 1 && level.f_46443_) {
            this.playMusic(pos);
        }
        return super.m_8133_(state, level, pos, i, j);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playMusic(BlockPos pos) {
        LevelRendererAccessor accessor = (LevelRendererAccessor)Minecraft.m_91087_().f_91060_;
        SoundInstance instance = accessor.getPlayingRecords().get(pos);
        SoundManager manager = Minecraft.m_91087_().m_91106_();
        if (instance == null || !manager.m_120403_(instance)) {
            Minecraft.m_91087_().f_91060_.m_109514_(ModSoundEvents.MUSIC.get(), pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        LevelRendererAccessor accessor = (LevelRendererAccessor)Minecraft.m_91087_().f_91060_;
        if ((double)random.m_188501_() <= 0.4) {
            SoundInstance instance = accessor.getPlayingRecords().get(pos);
            SoundManager manager = Minecraft.m_91087_().m_91106_();
            if (instance != null && manager.m_120403_(instance)) {
                int num = random.m_188503_(24);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.2 + random.m_188500_() / 2.0, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.2 + random.m_188500_() / 2.0, (double)((float)num / 24.0f), 0.0, 0.0);
            }
        }
    }
}

