/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.entities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.playdate.common.blocks.SittingBlock;
import tech.thatgravyboat.playdate.common.registry.ModEntities;

public class SittingEntity
extends Entity {
    public static final Multimap<ResourceKey<Level>, BlockPos> CURRENTLY_SITTING = ArrayListMultimap.create();
    private final BlockPos sittingPosition;
    private boolean markedForRemoval = false;
    private boolean canRotate = false;

    public SittingEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.sittingPosition = BlockPos.f_121853_;
    }

    private SittingEntity(BlockPos pos, Level level) {
        super(ModEntities.SEAT.get(), level);
        this.sittingPosition = pos;
    }

    public static SittingEntity of(Level level, BlockPos pos, Direction direction, boolean canRotate) {
        SittingEntity entity = new SittingEntity(pos, level);
        entity.canRotate = canRotate;
        entity.m_146922_(direction.m_122435_());
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        return entity;
    }

    public boolean m_6000_(double d, double e, double f) {
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_20160_() {
        return true;
    }

    public Vec3 m_7688_(@NotNull LivingEntity entity) {
        return RespawnAnchorBlock.m_55839_((EntityType)entity.m_6095_(), (CollisionGetter)this.f_19853_, (BlockPos)this.sittingPosition).orElseGet(() -> super.m_7688_(entity));
    }

    public void m_8119_() {
        boolean isSitting;
        super.m_8119_();
        if (!(this.f_19853_.m_5776_() || (isSitting = this.f_19853_.m_8055_(this.sittingPosition).m_60734_() instanceof SittingBlock) && !this.markedForRemoval)) {
            SittingEntity.getMap(this.f_19853_).remove(this.sittingPosition);
            this.m_146870_();
        }
    }

    protected void m_20351_(@NotNull Entity entity) {
        super.m_20351_(entity);
        if (this.m_20197_().isEmpty()) {
            this.markedForRemoval = true;
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
    }

    public void m_7340_(@NotNull Entity entity) {
        if (!this.canRotate) {
            entity.m_5618_(this.m_146908_());
            float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
            entity.f_19859_ += g - f;
            entity.m_146922_(entity.m_146908_() + g - f);
            entity.m_5616_(entity.m_146908_());
        }
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.canRotate ? 1 : 0);
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.canRotate = packet.m_131509_() == 1;
    }

    public static Collection<BlockPos> getMap(Level level) {
        return CURRENTLY_SITTING.get((Object)level.m_46472_());
    }
}

