/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.recipes;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.playdate.common.registry.ModRecipeSerializers;
import tech.thatgravyboat.playdate.common.registry.ModRecipes;

public record ToyBenchRecipe(ResourceLocation id, NonNullList<Ingredient> items, ItemStack result, int width, int height) implements Recipe<CraftingContainer>
{
    public boolean matches(CraftingContainer arg, @NotNull Level level) {
        for (int i = 0; i <= arg.m_39347_() - this.width; ++i) {
            for (int j = 0; j <= arg.m_39346_() - this.height; ++j) {
                if (this.matches(arg, i, j, true)) {
                    return true;
                }
                if (!this.matches(arg, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer arg, int x, int y, boolean bl) {
        for (int i = 0; i < arg.m_39347_(); ++i) {
            for (int j = 0; j < arg.m_39346_(); ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = (Ingredient)this.items.get(bl ? this.width - k - 1 + l * this.width : k + l * this.width);
                }
                if (ingredient.test(arg.m_8020_(i + j * arg.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(@NotNull CraftingContainer container) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int j) {
        return i >= this.width && j >= this.height;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.items;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> list = this.m_7527_();
        if (list.isEmpty()) {
            return true;
        }
        return list.stream().filter(Predicate.not(Ingredient::m_43947_)).anyMatch(ingredient -> ingredient.m_43908_().length == 0);
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.TOY_BENCH.get();
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.TOY_BENCH.get();
    }

    public static class Serializer
    implements RecipeSerializer<ToyBenchRecipe> {
        public ToyBenchRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject object) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(id, object);
            return new ToyBenchRecipe(id, (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_(), recipe.m_44220_(), recipe.m_44221_());
        }

        public ToyBenchRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(id, buffer);
            return new ToyBenchRecipe(id, (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_(), recipe.m_44220_(), recipe.m_44221_());
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull ToyBenchRecipe toyRecipe) {
            ShapedRecipe recipe = new ShapedRecipe(toyRecipe.m_6423_(), toyRecipe.m_6076_(), toyRecipe.width(), toyRecipe.height(), toyRecipe.m_7527_(), toyRecipe.m_8043_());
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe);
        }
    }
}

