/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.forge.playdate;

import java.util.HashMap;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tech.thatgravyboat.forge.playdate.PlaydateForgeClient;
import tech.thatgravyboat.forge.playdate.services.ForgeRegistryService;
import tech.thatgravyboat.playdate.Playdate;

@Mod(value="playdate")
public class PlaydateForge {
    public PlaydateForge() {
        Playdate.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PlaydateForge::addEntityAttributes);
        MinecraftForge.EVENT_BUS.addListener(PlaydateForge::onItemUse);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeRegistryService.BLOCKS_ENTITIES.register(bus);
        ForgeRegistryService.BLOCKS.register(bus);
        ForgeRegistryService.ITEMS.register(bus);
        ForgeRegistryService.ENTITIES.register(bus);
        ForgeRegistryService.PAINTINGS.register(bus);
        ForgeRegistryService.CONTAINERS.register(bus);
        ForgeRegistryService.RECIPES.register(bus);
        ForgeRegistryService.SOUNDS.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PlaydateForgeClient::init);
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> attributes = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
        Playdate.addEntityAttributes(attributes);
        attributes.forEach((entity, builder) -> event.put(entity, builder.m_22265_()));
    }

    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        InteractionResultHolder<ItemStack> result = Playdate.onItemUse(event.getPlayer(), event.getItemStack(), event.getWorld(), event.getHand());
        if (result.m_19089_().m_19077_()) {
            event.setCancellationResult(result.m_19089_());
            event.setCanceled(true);
        }
    }
}

