/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.forge.playdate.services;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import software.bernie.geckolib3.renderers.geo.GeoItemRenderer;
import tech.thatgravyboat.forge.playdate.client.DollHouseBlockRenderer;
import tech.thatgravyboat.forge.playdate.client.MusicBoxBlockRenderer;
import tech.thatgravyboat.forge.playdate.client.PlushieBlockRenderer;
import tech.thatgravyboat.forge.playdate.client.ToyBlockRenderer;
import tech.thatgravyboat.playdate.client.rendering.ToyBlockModel;
import tech.thatgravyboat.playdate.client.rendering.dollhouse.DollHouseBlockModel;
import tech.thatgravyboat.playdate.client.rendering.musicbox.MusicBoxBlockModel;
import tech.thatgravyboat.playdate.client.rendering.player.PlayerPlushieBlockModel;
import tech.thatgravyboat.playdate.client.rendering.plushie.PlushieBlockModel;
import tech.thatgravyboat.playdate.common.blocks.toys.PlushieBlockEntity;
import tech.thatgravyboat.playdate.common.blocks.toys.custom.player.PlayerPlushieBlockEntity;
import tech.thatgravyboat.playdate.platform.services.IClientHelper;

public class ForgeClientService
implements IClientHelper {
    public static final List<Tuple<ItemColor, Item[]>> COLOR_PROVIDERS = new ArrayList<Tuple<ItemColor, Item[]>>();

    @Override
    public void setRenderLayer(Block block, RenderType layer) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)layer);
    }

    @Override
    public <E extends Entity> void registerEntityRenderer(EntityType<E> type, EntityRendererProvider<E> factory) {
        EntityRenderers.m_174036_(type, factory);
    }

    @Override
    public <E extends BlockEntity> void registerBlockEntityRenderer(BlockEntityType<E> type, BlockEntityRendererProvider<E> factory) {
        BlockEntityRenderers.m_173590_(type, factory);
    }

    @Override
    public void registerItemRenderer(Item item, GeoItemRenderer renderer) {
    }

    @Override
    public void registerItemColor(ItemColor provider, Item ... items) {
        COLOR_PROVIDERS.add((Tuple<ItemColor, Item[]>)new Tuple((Object)provider, (Object)items));
    }

    @Override
    public <H extends AbstractContainerMenu, S extends Screen> void registerScreen(MenuType<H> type, IClientHelper.Factory<H, S> factory) {
        MenuScreens.m_96206_(type, factory::create);
    }

    @Override
    public void createPlushieRenderer(BlockEntityType<?> type) {
        this.registerBlockEntityRenderer(type, context -> new PlushieBlockRenderer<PlushieBlockEntity>(context, new PlushieBlockModel()));
    }

    @Override
    public void createPlayerPlushieRenderer(BlockEntityType<?> type) {
        this.registerBlockEntityRenderer(type, context -> new PlushieBlockRenderer<PlayerPlushieBlockEntity>(context, new PlayerPlushieBlockModel()));
    }

    @Override
    public void createToyRenderer(BlockEntityType<?> type) {
        this.registerBlockEntityRenderer(type, context -> new ToyBlockRenderer(context, new ToyBlockModel()));
    }

    @Override
    public void createDollHouseRenderer(BlockEntityType<?> type) {
        this.registerBlockEntityRenderer(type, context -> new DollHouseBlockRenderer(context, new DollHouseBlockModel()));
    }

    @Override
    public void createMusicBoxRenderer(BlockEntityType<?> type) {
        this.registerBlockEntityRenderer(type, context -> new MusicBoxBlockRenderer(context, new MusicBoxBlockModel()));
    }
}

