/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.forge.playdate.services;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.client.IItemRenderProperties;
import tech.thatgravyboat.playdate.client.rendering.dollhouse.DollHouseItemRenderer;
import tech.thatgravyboat.playdate.client.rendering.musicbox.MusicBoxItemRenderer;
import tech.thatgravyboat.playdate.client.rendering.player.PlayerPlushieItemRenderer;
import tech.thatgravyboat.playdate.client.rendering.plushie.PlushieItemRenderer;
import tech.thatgravyboat.playdate.common.blocks.BallPitBlock;
import tech.thatgravyboat.playdate.common.constants.CuddleCub;
import tech.thatgravyboat.playdate.common.constants.Doll;
import tech.thatgravyboat.playdate.common.constants.PlayerSkin;
import tech.thatgravyboat.playdate.common.constants.PlushieItem;
import tech.thatgravyboat.playdate.common.items.CuddleCubItem;
import tech.thatgravyboat.playdate.common.items.DollHouseItem;
import tech.thatgravyboat.playdate.common.items.DollItem;
import tech.thatgravyboat.playdate.common.items.MusicBoxItem;
import tech.thatgravyboat.playdate.common.items.PlayerPlushieItem;
import tech.thatgravyboat.playdate.common.items.PlushItem;
import tech.thatgravyboat.playdate.platform.services.IPlatformHelper;

public class ForgePlatformService
implements IPlatformHelper {
    public static void createPlushieRenderer(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = PlushieItemRenderer.create();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    @Override
    public PlushItem createPlush(Block block, PlushieItem plushie, Item.Properties settings) {
        return new PlushItem(block, plushie, settings){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                super.initializeClient(consumer);
                ForgePlatformService.createPlushieRenderer(consumer);
            }
        };
    }

    @Override
    public CuddleCubItem createCub(Block block, CuddleCub cub, Item.Properties settings) {
        return new CuddleCubItem(block, cub, settings){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                super.initializeClient(consumer);
                ForgePlatformService.createPlushieRenderer(consumer);
            }
        };
    }

    @Override
    public PlayerPlushieItem createPlayer(Block block, PlayerSkin defaultSkin, Item.Properties settings) {
        return new PlayerPlushieItem(block, defaultSkin, settings){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                super.initializeClient(consumer);
                consumer.accept(new IItemRenderProperties(){
                    private final BlockEntityWithoutLevelRenderer renderer = PlayerPlushieItemRenderer.create();

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return this.renderer;
                    }
                });
            }
        };
    }

    @Override
    public DollHouseItem createDollhouse(Block block, Doll defaultSkin, Item.Properties settings) {
        return new DollHouseItem(block, defaultSkin, settings){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                super.initializeClient(consumer);
                consumer.accept(new IItemRenderProperties(){
                    private final BlockEntityWithoutLevelRenderer renderer = DollHouseItemRenderer.create();

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return this.renderer;
                    }
                });
            }
        };
    }

    @Override
    public DollItem createDoll(Block block, Doll doll, Item.Properties settings) {
        return new DollItem(block, doll, settings){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                super.initializeClient(consumer);
                ForgePlatformService.createPlushieRenderer(consumer);
            }
        };
    }

    @Override
    public BallPitBlock createBallpitBlock(BlockBehaviour.Properties settings) {
        return new BallPitBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60988_()){

            public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
                return true;
            }
        };
    }

    @Override
    public MusicBoxItem createMusicBox(Block block, Item.Properties settings) {
        return new MusicBoxItem(block, settings){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                super.initializeClient(consumer);
                consumer.accept(new IItemRenderProperties(){
                    private final BlockEntityWithoutLevelRenderer renderer = MusicBoxItemRenderer.create();

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return this.renderer;
                    }
                });
            }
        };
    }
}

