/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.forge.playdate.services;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import tech.thatgravyboat.playdate.platform.services.IRegistryHelper;

public class ForgeRegistryService
implements IRegistryHelper {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"playdate");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"playdate");
    public static final DeferredRegister<BlockEntityType<?>> BLOCKS_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"playdate");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"playdate");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"playdate");
    public static final DeferredRegister<Motive> PAINTINGS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PAINTING_TYPES, (String)"playdate");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"playdate");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"playdate");

    @Override
    public <T extends Block> Supplier<T> registerBlock(String id, Supplier<T> block) {
        return BLOCKS.register(id, block);
    }

    @Override
    public <T extends Item> Supplier<T> registerItem(String id, Supplier<T> item) {
        return ITEMS.register(id, item);
    }

    @Override
    public <T extends BlockEntityType<?>> Supplier<T> registerBlockEntity(String id, Supplier<T> blockEntity) {
        return BLOCKS_ENTITIES.register(id, blockEntity);
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(String id, EntityType.EntityFactory<T> factory, MobCategory group, float height, float width) {
        return ENTITIES.register(id, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)factory, (MobCategory)group).m_20699_(width, height).m_20712_(id));
    }

    @Override
    public <E extends Recipe<?>, T extends RecipeSerializer<E>> Supplier<T> registerRecipe(String id, Supplier<T> serializer) {
        return RECIPES.register(id, serializer);
    }

    @Override
    public Supplier<SoundEvent> registerSound(String id, Supplier<SoundEvent> sound) {
        return SOUNDS.register(id, sound);
    }

    @Override
    public Supplier<Motive> registerPainting(String id, Supplier<Motive> serializer) {
        return PAINTINGS.register(id, serializer);
    }

    @Override
    public CreativeModeTab createItemGroup(ResourceLocation id, final Supplier<ItemStack> stack) {
        return new CreativeModeTab(id.m_135827_() + "." + id.m_135815_()){

            public ItemStack m_6976_() {
                return (ItemStack)stack.get();
            }
        };
    }

    @Override
    public <T extends AbstractContainerMenu> Supplier<MenuType<T>> registerContainer(String id, IRegistryHelper.ContainerFactory<T> factory) {
        return CONTAINERS.register(id, () -> IForgeMenuType.create((syncId, inv, c) -> factory.create(syncId, inv)));
    }

    @Override
    public <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(IRegistryHelper.BlockEntityFactory<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(factory::create, (Block[])blocks).m_58966_(null);
    }
}

