/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.GeckoLib;
import tech.thatgravyboat.playdate.common.entity.ToyEntity;
import tech.thatgravyboat.playdate.common.registry.ModBlockEntities;
import tech.thatgravyboat.playdate.common.registry.ModBlocks;
import tech.thatgravyboat.playdate.common.registry.ModContainers;
import tech.thatgravyboat.playdate.common.registry.ModEntities;
import tech.thatgravyboat.playdate.common.registry.ModItems;
import tech.thatgravyboat.playdate.common.registry.ModPaintings;
import tech.thatgravyboat.playdate.common.registry.ModRecipes;
import tech.thatgravyboat.playdate.common.registry.ModSounds;
import tech.thatgravyboat.playdate.platform.CommonServices;

public class Playdate {
    public static final String MODID = "playdate";
    public static final CreativeModeTab ITEM_GROUP = CommonServices.REGISTRY.createItemGroup(Playdate.modId("playdate_group"), () -> new ItemStack((ItemLike)ModItems.STUFFING.get()));

    public static void init() {
        GeckoLib.initialize();
        ModBlockEntities.register();
        ModBlocks.register();
        ModItems.register();
        ModEntities.register();
        ModPaintings.register();
        ModContainers.register();
        ModRecipes.register();
        ModSounds.register();
    }

    public static void addEntityAttributes(Map<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> attributes) {
        attributes.put(ModEntities.LOLLIPOP_CLOWN.get(), ToyEntity.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.4));
        attributes.put(ModEntities.HAPPY_SUN.get(), ToyEntity.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.4));
        attributes.put(ModEntities.PETUNIA_PIG.get(), ToyEntity.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.4));
        attributes.put(ModEntities.STUFFIE.get(), ToyEntity.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.4));
        attributes.put(ModEntities.SOCK_MONKEY.get(), ToyEntity.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, 0.3));
    }

    public static InteractionResultHolder<ItemStack> onItemUse(Player player, ItemStack stack, Level world, InteractionHand hand) {
        BlockPos blockPos;
        BlockHitResult result;
        if (stack.m_150930_(Items.f_42590_) && (result = Playdate.raycast(world, player)).m_6662_().equals((Object)HitResult.Type.BLOCK) && world.m_8055_(blockPos = result.m_82425_()).m_60713_(Blocks.f_50135_)) {
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12394_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            world.m_46597_(blockPos, Blocks.f_50136_.m_49966_());
            world.m_5594_(player, blockPos, SoundEvents.f_12219_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return InteractionResultHolder.m_19090_((Object)ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.BOTTLED_SOUL.get())));
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    protected static BlockHitResult raycast(Level world, Player player) {
        float f = player.m_146909_();
        float g = player.m_146908_();
        Vec3 vec3d = player.m_146892_();
        float h = Mth.m_14089_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.m_14031_((float)(-g * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        Vec3 vec3d2 = vec3d.m_82520_((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return world.m_45547_(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)player));
    }

    public static ResourceLocation modId(String path) {
        return new ResourceLocation(MODID, path);
    }
}

