/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.AnimationUtils;
import tech.thatgravyboat.playdate.client.rendering.BalloonModel;
import tech.thatgravyboat.playdate.common.entity.BalloonEntity;
import tech.thatgravyboat.playdate.common.utils.Color;

public class BalloonRenderer
extends EntityRenderer<BalloonEntity>
implements IGeoRenderer<BalloonEntity> {
    private final AnimatedGeoModel<BalloonEntity> modelProvider = new BalloonModel();
    public MultiBufferSource rtb;
    public ResourceLocation whTexture;

    public BalloonRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(BalloonEntity entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.m_85836_();
        boolean shouldSit = entity.m_20159_() && entity.m_20202_() != null;
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entity, 0.0f, 0.0f, partialTicks, false, Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation((Object)entity));
        this.modelProvider.setLivingAnimations((IAnimatable)entity, this.getUniqueID(entity), predicate);
        stack.m_85837_(0.0, (double)0.01f, 0.0);
        stack.m_85845_(Vector3f.f_122224_.m_122240_((float)(entity.m_142081_().getLeastSignificantBits() % 360L)));
        Minecraft.m_91087_().m_91097_().m_174784_(this.getTexture(entity));
        RenderType renderType = this.getRenderType((Object)entity, partialTicks, stack, bufferIn, null, packedLightIn, this.getTexture(entity));
        boolean invis = entity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        int color = !entity.getTexture().colored ? -1 : (entity.isRainbow() ? Color.RAINBOW.getRGBA() : entity.getColor());
        this.render(model, (Object)entity, partialTicks, renderType, stack, bufferIn, null, packedLightIn, OverlayTexture.m_118090_((float)OverlayTexture.m_118088_((float)0.0f), (boolean)false), (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f, invis ? 0.0f : 1.0f);
        stack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        this.renderLeash(entity, partialTicks, stack, bufferIn);
    }

    public Integer getUniqueID(BalloonEntity animatable) {
        return animatable.m_142081_().hashCode();
    }

    public void renderEarly(BalloonEntity animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        this.rtb = renderTypeBuffer;
        this.whTexture = this.getTextureLocation(animatable);
        super.renderEarly((Object)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
    }

    public ResourceLocation getTexture(BalloonEntity entity) {
        return this.getTextureLocation(entity);
    }

    public void setCurrentRTB(MultiBufferSource rtb) {
        this.rtb = rtb;
    }

    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    public GeoModelProvider<BalloonEntity> getGeoModelProvider() {
        return this.modelProvider;
    }

    protected boolean hasLabel(BalloonEntity entity) {
        return false;
    }

    public ResourceLocation getTextureLocation(BalloonEntity instance) {
        return this.modelProvider.getTextureLocation((Object)instance);
    }

    private void renderLeash(BalloonEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource provider) {
        int u;
        Entity holder = entity.getHolder();
        matrices.m_85836_();
        Vec3 vec3d = holder == null ? new Vec3(entity.m_20185_() + 0.001, entity.m_20186_() - (double)entity.getRopeLength(), entity.m_20189_() + 0.001) : holder.m_7398_(tickDelta);
        double g = Mth.m_14139_((double)tickDelta, (double)entity.f_19854_, (double)entity.m_20185_());
        double h = Mth.m_14139_((double)tickDelta, (double)entity.f_19855_, (double)entity.m_20186_());
        double i = Mth.m_14139_((double)tickDelta, (double)entity.f_19856_, (double)entity.m_20189_());
        float j = (float)(vec3d.f_82479_ - g);
        float k = (float)(vec3d.f_82480_ - h);
        float l = (float)(vec3d.f_82481_ - i);
        VertexConsumer vertexConsumer = provider.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = matrices.m_85850_().m_85861_();
        float n = Mth.m_14195_((float)(j * j + l * l)) * 0.025f / 2.0f;
        float o = l * n;
        float p = j * n;
        BlockPos blockPos = new BlockPos(entity.m_20299_(tickDelta));
        BlockPos blockPos2 = holder == null ? blockPos : new BlockPos(holder.m_20299_(tickDelta));
        int q = this.m_6086_(entity, blockPos);
        int r = holder != null && holder.m_6060_() ? 15 : entity.f_19853_.m_45517_(LightLayer.BLOCK, blockPos2);
        int s = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos);
        int t = entity.f_19853_.m_45517_(LightLayer.SKY, blockPos2);
        for (u = 0; u <= 24; ++u) {
            BalloonRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.025f, o, p, u, false);
        }
        for (u = 24; u >= 0; --u) {
            BalloonRenderer.renderLeashPiece(vertexConsumer, matrix4f, j, k, l, q, r, s, t, 0.025f, 0.0f, o, p, u, true);
        }
        matrices.m_85849_();
    }

    private static void renderLeashPiece(VertexConsumer vertexConsumer, Matrix4f positionMatrix, float f, float g, float h, int leashedEntityBlockLight, int holdingEntityBlockLight, int leashedEntitySkyLight, int holdingEntitySkyLight, float i, float j, float k, float l, int pieceIndex, boolean isLeashKnot) {
        float m = (float)pieceIndex / 24.0f;
        int n = (int)Mth.m_14179_((float)m, (float)leashedEntityBlockLight, (float)holdingEntityBlockLight);
        int o = (int)Mth.m_14179_((float)m, (float)leashedEntitySkyLight, (float)holdingEntitySkyLight);
        int p = LightTexture.m_109885_((int)n, (int)o);
        float q = pieceIndex % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.5f * q;
        float s = 0.4f * q;
        float t = 0.3f * q;
        float u = f * m;
        float v = g > 0.0f ? g * m * m : g - g * (1.0f - m) * (1.0f - m);
        float w = h * m;
        vertexConsumer.m_85982_(positionMatrix, u - k, v + j, w + l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
        vertexConsumer.m_85982_(positionMatrix, u + k, v + i - j, w - l).m_85950_(r, s, t, 1.0f).m_85969_(p).m_5752_();
    }

    static {
        AnimationController.addModelFetcher(object -> {
            if (object instanceof BalloonEntity) {
                return (IAnimatableModel)AnimationUtils.getGeoModelForEntity((Entity)((BalloonEntity)((Object)object)));
            }
            return null;
        });
    }
}

