/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.blocks.musicbox;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.playdate.common.blocks.musicbox.MusicBoxBlockEntity;

public class MusicBoxBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0);
    private final Supplier<BlockEntityType<?>> blockEntityType;
    public static final BooleanProperty PLAYING = BooleanProperty.m_61465_((String)"playing");

    public MusicBoxBlock(Supplier<BlockEntityType<?>> blockEntityType, BlockBehaviour.Properties settings) {
        super(settings);
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60734_() != newState.m_60734_()) {
            world.m_46796_(1010, pos, 0);
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(true)));
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public static boolean isPlaying(BlockState state) {
        return state.m_61138_((Property)PLAYING) && (Boolean)state.m_61143_((Property)PLAYING) != false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)PLAYING, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PLAYING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.f_46443_) {
            return null;
        }
        return MusicBoxBlock.checkType(type, this.blockEntityType.get(), MusicBoxBlockEntity::tick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int type, int data) {
        super.m_8133_(state, world, pos, type, data);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(type, data);
    }
}

