/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.blocks.musicbox;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.playdate.common.blocks.musicbox.MusicBoxBlock;
import tech.thatgravyboat.playdate.common.registry.ModSounds;

public class MusicBoxBlockEntity
extends BlockEntity
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int time = 0;

    public MusicBoxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof MusicBoxBlockEntity) {
            MusicBoxBlockEntity musicBoxBlock = (MusicBoxBlockEntity)blockEntity;
            if (MusicBoxBlock.isPlaying(state)) {
                if (musicBoxBlock.time == 0) {
                    world.m_7696_(pos, state.m_60734_(), 1, 0);
                }
                ++musicBoxBlock.time;
            } else {
                musicBoxBlock.time = 0;
            }
            if (musicBoxBlock.time == 681) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)MusicBoxBlock.PLAYING, (Comparable)Boolean.valueOf(false)));
                musicBoxBlock.time = 0;
            }
        }
    }

    public boolean m_7531_(int type, int data) {
        if (type == 1) {
            if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
                this.playSong();
            }
            return true;
        }
        return super.m_7531_(type, data);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playSong() {
        Minecraft.m_91087_().f_91060_.m_109514_(ModSounds.MUSIC_BOX.get(), this.f_58858_);
    }

    protected <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (MusicBoxBlock.isPlaying(this.m_58900_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("spin", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

