/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.blocks.toys;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.playdate.common.blocks.toys.ToyBlockEntity;
import tech.thatgravyboat.playdate.common.registry.ModItems;

public class ToyBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)26.0, (double)13.0);
    public static BooleanProperty POSSESSED = BooleanProperty.m_61465_((String)"possessed");
    private final Supplier<EntityType<?>> toyEntity;
    private final Supplier<BlockEntityType<?>> blockEntityType;

    public ToyBlock(Supplier<EntityType<?>> toyEntity, Supplier<BlockEntityType<?>> blockEntityType, BlockBehaviour.Properties settings) {
        super(settings);
        this.toyEntity = toyEntity;
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POSSESSED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, POSSESSED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(ModItems.BOTTLED_SOUL.get()) && !((Boolean)state.m_61143_((Property)POSSESSED)).booleanValue() && !world.m_46791_().equals((Object)Difficulty.PEACEFUL)) {
            ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_));
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POSSESSED, (Comparable)Boolean.valueOf(true)));
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level tickingWorld, BlockState blockState, BlockEntityType<T> type) {
        return ToyBlock.m_152132_(type, this.blockEntityType.get(), (world, pos, state, entity) -> ToyBlockEntity.tick(world, pos, state, this.toyEntity.get()));
    }
}

