/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.playdate.common.constants;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import tech.thatgravyboat.playdate.common.blocks.LetterBlock;
import tech.thatgravyboat.playdate.common.registry.ModBlocks;
import tech.thatgravyboat.playdate.common.registry.ModItems;
import tech.thatgravyboat.playdate.platform.CommonServices;

public class Letters {
    public static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";

    public static List<Supplier<Block>> createBlocks() {
        ArrayList<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>(LETTERS.length());
        for (int i = 0; i < LETTERS.length(); ++i) {
            int finalI = i;
            blocks.add(CommonServices.REGISTRY.registerBlock(Letters.formatFromId(i), () -> new LetterBlock(finalI, ModBlocks.SOFTWOOD_SETTINGS)));
        }
        return blocks;
    }

    public static List<Supplier<BlockItem>> createBlockItems() {
        ArrayList<Supplier<BlockItem>> blocks = new ArrayList<Supplier<BlockItem>>(LETTERS.length());
        for (int i = 0; i < LETTERS.length(); ++i) {
            int finalI = i;
            blocks.add(CommonServices.REGISTRY.registerItem(Letters.formatFromId(i), () -> new BlockItem(ModBlocks.LETTER_BLOCKS.get(finalI).get(), ModItems.GROUP_SETTINGS)));
        }
        return blocks;
    }

    public static String formatFromId(int id) {
        return "letter_" + LETTERS.charAt(id);
    }

    public static Block getLetterBlock(char character) {
        int i = LETTERS.indexOf(character);
        if (i == -1) {
            return null;
        }
        return ModBlocks.LETTER_BLOCKS.get(i).get();
    }
}

